package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  CommitId,
  JobId,
  AppId,
  JobReason,
  CommitTime,
  BranchName,
  CommitMessage
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StartJobRequest(
    appId: AppId,
    branchName: BranchName,
    jobId: Option[JobId] = None,
    jobType: zio.aws.amplify.model.JobType,
    jobReason: Option[JobReason] = None,
    commitId: Option[CommitId] = None,
    commitMessage: Option[CommitMessage] = None,
    commitTime: Option[CommitTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.StartJobRequest = {
    import StartJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.StartJobRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .jobType(jobType.unwrap)
      .optionallyWith(
        jobReason.map(value => JobReason.unwrap(value): java.lang.String)
      )(_.jobReason)
      .optionallyWith(
        commitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.commitId)
      .optionallyWith(
        commitMessage.map(value =>
          CommitMessage.unwrap(value): java.lang.String
        )
      )(_.commitMessage)
      .optionallyWith(
        commitTime.map(value => CommitTime.unwrap(value): Instant)
      )(_.commitTime)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.StartJobRequest.ReadOnly =
    zio.aws.amplify.model.StartJobRequest.wrap(buildAwsValue())
}
object StartJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.StartJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.StartJobRequest =
      zio.aws.amplify.model.StartJobRequest(
        appId,
        branchName,
        jobId.map(value => value),
        jobType,
        jobReason.map(value => value),
        commitId.map(value => value),
        commitMessage.map(value => value),
        commitTime.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def jobId: Option[JobId]
    def jobType: zio.aws.amplify.model.JobType
    def jobReason: Option[JobReason]
    def commitId: Option[CommitId]
    def commitMessage: Option[CommitMessage]
    def commitTime: Option[CommitTime]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobType: ZIO[Any, Nothing, zio.aws.amplify.model.JobType] =
      ZIO.succeed(jobType)
    def getJobReason: ZIO[Any, AwsError, JobReason] =
      AwsError.unwrapOptionField("jobReason", jobReason)
    def getCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getCommitMessage: ZIO[Any, AwsError, CommitMessage] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getCommitTime: ZIO[Any, AwsError, CommitTime] =
      AwsError.unwrapOptionField("commitTime", commitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.StartJobRequest
  ) extends zio.aws.amplify.model.StartJobRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.amplify.model.primitives.JobId(value))
    override val jobType: zio.aws.amplify.model.JobType =
      zio.aws.amplify.model.JobType.wrap(impl.jobType())
    override val jobReason: Option[JobReason] = scala
      .Option(impl.jobReason())
      .map(value => zio.aws.amplify.model.primitives.JobReason(value))
    override val commitId: Option[CommitId] = scala
      .Option(impl.commitId())
      .map(value => zio.aws.amplify.model.primitives.CommitId(value))
    override val commitMessage: Option[CommitMessage] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.amplify.model.primitives.CommitMessage(value))
    override val commitTime: Option[CommitTime] = scala
      .Option(impl.commitTime())
      .map(value => zio.aws.amplify.model.primitives.CommitTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.StartJobRequest
  ): zio.aws.amplify.model.StartJobRequest.ReadOnly = new Wrapper(impl)
}
