package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableNotification,
  EnableAutoBuild,
  DisplayName,
  PullRequestEnvironmentName,
  TTL,
  BuildSpec,
  EnablePullRequestPreview,
  BasicAuthCredentials,
  Description,
  EnablePerformanceMode,
  AppId,
  EnvValue,
  EnvKey,
  BackendEnvironmentArn,
  Framework,
  BranchName
}
import scala.jdk.CollectionConverters.*
final case class UpdateBranchRequest(
    appId: AppId,
    branchName: BranchName,
    description: Option[Description] = None,
    framework: Option[Framework] = None,
    stage: Option[zio.aws.amplify.model.Stage] = None,
    enableNotification: Option[EnableNotification] = None,
    enableAutoBuild: Option[EnableAutoBuild] = None,
    environmentVariables: Option[Map[EnvKey, EnvValue]] = None,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    enableBasicAuth: Option[EnableBasicAuth] = None,
    enablePerformanceMode: Option[EnablePerformanceMode] = None,
    buildSpec: Option[BuildSpec] = None,
    ttl: Option[TTL] = None,
    displayName: Option[DisplayName] = None,
    enablePullRequestPreview: Option[EnablePullRequestPreview] = None,
    pullRequestEnvironmentName: Option[PullRequestEnvironmentName] = None,
    backendEnvironmentArn: Option[BackendEnvironmentArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateBranchRequest = {
    import UpdateBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateBranchRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        framework.map(value => Framework.unwrap(value): java.lang.String)
      )(_.framework)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .optionallyWith(
        enableNotification.map(value =>
          EnableNotification.unwrap(value): java.lang.Boolean
        )
      )(_.enableNotification)
      .optionallyWith(
        enableAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBuild)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        enablePerformanceMode.map(value =>
          EnablePerformanceMode.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceMode)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(ttl.map(value => TTL.unwrap(value): java.lang.String))(
        _.ttl
      )
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enablePullRequestPreview.map(value =>
          EnablePullRequestPreview.unwrap(value): java.lang.Boolean
        )
      )(_.enablePullRequestPreview)
      .optionallyWith(
        pullRequestEnvironmentName.map(value =>
          PullRequestEnvironmentName.unwrap(value): java.lang.String
        )
      )(_.pullRequestEnvironmentName)
      .optionallyWith(
        backendEnvironmentArn.map(value =>
          BackendEnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentArn)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateBranchRequest.ReadOnly =
    zio.aws.amplify.model.UpdateBranchRequest.wrap(buildAwsValue())
}
object UpdateBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateBranchRequest =
      zio.aws.amplify.model.UpdateBranchRequest(
        appId,
        branchName,
        description.map(value => value),
        framework.map(value => value),
        stage.map(value => value),
        enableNotification.map(value => value),
        enableAutoBuild.map(value => value),
        environmentVariables.map(value => value),
        basicAuthCredentials.map(value => value),
        enableBasicAuth.map(value => value),
        enablePerformanceMode.map(value => value),
        buildSpec.map(value => value),
        ttl.map(value => value),
        displayName.map(value => value),
        enablePullRequestPreview.map(value => value),
        pullRequestEnvironmentName.map(value => value),
        backendEnvironmentArn.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def description: Option[Description]
    def framework: Option[Framework]
    def stage: Option[zio.aws.amplify.model.Stage]
    def enableNotification: Option[EnableNotification]
    def enableAutoBuild: Option[EnableAutoBuild]
    def environmentVariables: Option[Map[EnvKey, EnvValue]]
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def enableBasicAuth: Option[EnableBasicAuth]
    def enablePerformanceMode: Option[EnablePerformanceMode]
    def buildSpec: Option[BuildSpec]
    def ttl: Option[TTL]
    def displayName: Option[DisplayName]
    def enablePullRequestPreview: Option[EnablePullRequestPreview]
    def pullRequestEnvironmentName: Option[PullRequestEnvironmentName]
    def backendEnvironmentArn: Option[BackendEnvironmentArn]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getFramework: ZIO[Any, AwsError, Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getStage: ZIO[Any, AwsError, zio.aws.amplify.model.Stage] =
      AwsError.unwrapOptionField("stage", stage)
    def getEnableNotification: ZIO[Any, AwsError, EnableNotification] =
      AwsError.unwrapOptionField("enableNotification", enableNotification)
    def getEnableAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableAutoBuild", enableAutoBuild)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getEnablePerformanceMode: ZIO[Any, AwsError, EnablePerformanceMode] =
      AwsError.unwrapOptionField("enablePerformanceMode", enablePerformanceMode)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getTtl: ZIO[Any, AwsError, TTL] = AwsError.unwrapOptionField("ttl", ttl)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnablePullRequestPreview
        : ZIO[Any, AwsError, EnablePullRequestPreview] = AwsError
      .unwrapOptionField("enablePullRequestPreview", enablePullRequestPreview)
    def getPullRequestEnvironmentName
        : ZIO[Any, AwsError, PullRequestEnvironmentName] =
      AwsError.unwrapOptionField(
        "pullRequestEnvironmentName",
        pullRequestEnvironmentName
      )
    def getBackendEnvironmentArn: ZIO[Any, AwsError, BackendEnvironmentArn] =
      AwsError.unwrapOptionField("backendEnvironmentArn", backendEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateBranchRequest
  ) extends zio.aws.amplify.model.UpdateBranchRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
    override val framework: Option[Framework] = scala
      .Option(impl.framework())
      .map(value => zio.aws.amplify.model.primitives.Framework(value))
    override val stage: Option[zio.aws.amplify.model.Stage] = scala
      .Option(impl.stage())
      .map(value => zio.aws.amplify.model.Stage.wrap(value))
    override val enableNotification: Option[EnableNotification] = scala
      .Option(impl.enableNotification())
      .map(value => zio.aws.amplify.model.primitives.EnableNotification(value))
    override val enableAutoBuild: Option[EnableAutoBuild] = scala
      .Option(impl.enableAutoBuild())
      .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val environmentVariables: Option[Map[EnvKey, EnvValue]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
          })
          .toMap
      )
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val enableBasicAuth: Option[EnableBasicAuth] = scala
      .Option(impl.enableBasicAuth())
      .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val enablePerformanceMode: Option[EnablePerformanceMode] = scala
      .Option(impl.enablePerformanceMode())
      .map(value =>
        zio.aws.amplify.model.primitives.EnablePerformanceMode(value)
      )
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val ttl: Option[TTL] = scala
      .Option(impl.ttl())
      .map(value => zio.aws.amplify.model.primitives.TTL(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.amplify.model.primitives.DisplayName(value))
    override val enablePullRequestPreview: Option[EnablePullRequestPreview] =
      scala
        .Option(impl.enablePullRequestPreview())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePullRequestPreview(value)
        )
    override val pullRequestEnvironmentName
        : Option[PullRequestEnvironmentName] = scala
      .Option(impl.pullRequestEnvironmentName())
      .map(value =>
        zio.aws.amplify.model.primitives.PullRequestEnvironmentName(value)
      )
    override val backendEnvironmentArn: Option[BackendEnvironmentArn] = scala
      .Option(impl.backendEnvironmentArn())
      .map(value =>
        zio.aws.amplify.model.primitives.BackendEnvironmentArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateBranchRequest
  ): zio.aws.amplify.model.UpdateBranchRequest.ReadOnly = new Wrapper(impl)
}
