package zio.aws.amplify
import zio.aws.amplify.model.ListBranchesResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.amplify.model.{
  CreateAppRequest,
  GetDomainAssociationResponse,
  GetBranchResponse,
  UpdateAppResponse,
  ListBranchesResponse,
  StopJobResponse,
  DeleteDomainAssociationRequest,
  ListAppsResponse,
  UpdateBranchResponse,
  StartDeploymentRequest,
  ListArtifactsResponse,
  UpdateAppRequest,
  DeleteDomainAssociationResponse,
  ListJobsRequest,
  GetBackendEnvironmentRequest,
  ListBackendEnvironmentsRequest,
  StartJobResponse,
  UpdateDomainAssociationResponse,
  GetJobRequest,
  CreateWebhookRequest,
  ListBackendEnvironmentsResponse,
  UpdateWebhookResponse,
  CreateBackendEnvironmentRequest,
  GetBranchRequest,
  ListTagsForResourceRequest,
  CreateDomainAssociationRequest,
  GetWebhookRequest,
  GetAppResponse,
  DeleteJobResponse,
  GenerateAccessLogsResponse,
  GetJobResponse,
  CreateBranchRequest,
  ListWebhooksResponse,
  CreateDeploymentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteJobRequest,
  CreateBackendEnvironmentResponse,
  GetWebhookResponse,
  DeleteBranchResponse,
  ListArtifactsRequest,
  ListDomainAssociationsResponse,
  GetDomainAssociationRequest,
  GetArtifactUrlResponse,
  GetAppRequest,
  GetArtifactUrlRequest,
  GetBackendEnvironmentResponse,
  DeleteWebhookRequest,
  UntagResourceRequest,
  ListBranchesRequest,
  ListWebhooksRequest,
  DeleteAppResponse,
  ListDomainAssociationsRequest,
  StartDeploymentResponse,
  ListAppsRequest,
  CreateDeploymentRequest,
  ListJobsResponse,
  StartJobRequest,
  CreateDomainAssociationResponse,
  DeleteBackendEnvironmentResponse,
  UpdateBranchRequest,
  DeleteAppRequest,
  CreateBranchResponse,
  TagResourceResponse,
  CreateAppResponse,
  UpdateDomainAssociationRequest,
  GenerateAccessLogsRequest,
  DeleteBranchRequest,
  TagResourceRequest,
  DeleteWebhookResponse,
  DeleteBackendEnvironmentRequest,
  StopJobRequest,
  UpdateWebhookRequest,
  CreateWebhookResponse
}
import software.amazon.awssdk.services.amplify.{
  AmplifyAsyncClientBuilder,
  AmplifyAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters.*
trait Amplify extends AspectSupport[Amplify] {
  val api: AmplifyAsyncClient
  def getWebhook(
      request: zio.aws.amplify.model.GetWebhookRequest
  ): IO[AwsError, zio.aws.amplify.model.GetWebhookResponse.ReadOnly]
  def getArtifactUrl(
      request: zio.aws.amplify.model.GetArtifactUrlRequest
  ): IO[AwsError, zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly]
  def getApp(
      request: zio.aws.amplify.model.GetAppRequest
  ): IO[AwsError, zio.aws.amplify.model.GetAppResponse.ReadOnly]
  def deleteBackendEnvironment(
      request: zio.aws.amplify.model.DeleteBackendEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly
  ]
  def listWebhooks(
      request: zio.aws.amplify.model.ListWebhooksRequest
  ): IO[AwsError, zio.aws.amplify.model.ListWebhooksResponse.ReadOnly]
  def startJob(
      request: zio.aws.amplify.model.StartJobRequest
  ): IO[AwsError, zio.aws.amplify.model.StartJobResponse.ReadOnly]
  def listApps(
      request: zio.aws.amplify.model.ListAppsRequest
  ): IO[AwsError, zio.aws.amplify.model.ListAppsResponse.ReadOnly]
  def deleteBranch(
      request: zio.aws.amplify.model.DeleteBranchRequest
  ): IO[AwsError, zio.aws.amplify.model.DeleteBranchResponse.ReadOnly]
  def deleteWebhook(
      request: zio.aws.amplify.model.DeleteWebhookRequest
  ): IO[AwsError, zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly]
  def stopJob(
      request: zio.aws.amplify.model.StopJobRequest
  ): IO[AwsError, zio.aws.amplify.model.StopJobResponse.ReadOnly]
  def updateApp(
      request: zio.aws.amplify.model.UpdateAppRequest
  ): IO[AwsError, zio.aws.amplify.model.UpdateAppResponse.ReadOnly]
  def createApp(
      request: zio.aws.amplify.model.CreateAppRequest
  ): IO[AwsError, zio.aws.amplify.model.CreateAppResponse.ReadOnly]
  def updateWebhook(
      request: zio.aws.amplify.model.UpdateWebhookRequest
  ): IO[AwsError, zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly]
  def createBranch(
      request: zio.aws.amplify.model.CreateBranchRequest
  ): IO[AwsError, zio.aws.amplify.model.CreateBranchResponse.ReadOnly]
  def updateDomainAssociation(
      request: zio.aws.amplify.model.UpdateDomainAssociationRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.UpdateDomainAssociationResponse.ReadOnly
  ]
  def deleteApp(
      request: zio.aws.amplify.model.DeleteAppRequest
  ): IO[AwsError, zio.aws.amplify.model.DeleteAppResponse.ReadOnly]
  def listArtifacts(
      request: zio.aws.amplify.model.ListArtifactsRequest
  ): IO[AwsError, zio.aws.amplify.model.ListArtifactsResponse.ReadOnly]
  def listBranches(
      request: zio.aws.amplify.model.ListBranchesRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(
      request: zio.aws.amplify.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.amplify.model.UntagResourceResponse.ReadOnly]
  def createDeployment(
      request: zio.aws.amplify.model.CreateDeploymentRequest
  ): IO[AwsError, zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly]
  def getJob(
      request: zio.aws.amplify.model.GetJobRequest
  ): IO[AwsError, zio.aws.amplify.model.GetJobResponse.ReadOnly]
  def createBackendEnvironment(
      request: zio.aws.amplify.model.CreateBackendEnvironmentRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.CreateBackendEnvironmentResponse.ReadOnly
  ]
  def listBackendEnvironments(
      request: zio.aws.amplify.model.ListBackendEnvironmentsRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly
  ]
  def createDomainAssociation(
      request: zio.aws.amplify.model.CreateDomainAssociationRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.CreateDomainAssociationResponse.ReadOnly
  ]
  def getBranch(
      request: zio.aws.amplify.model.GetBranchRequest
  ): IO[AwsError, zio.aws.amplify.model.GetBranchResponse.ReadOnly]
  def listDomainAssociations(
      request: zio.aws.amplify.model.ListDomainAssociationsRequest
  ): IO[AwsError, zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.amplify.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.amplify.model.ListTagsForResourceResponse.ReadOnly]
  def listJobs(
      request: zio.aws.amplify.model.ListJobsRequest
  ): IO[AwsError, zio.aws.amplify.model.ListJobsResponse.ReadOnly]
  def createWebhook(
      request: zio.aws.amplify.model.CreateWebhookRequest
  ): IO[AwsError, zio.aws.amplify.model.CreateWebhookResponse.ReadOnly]
  def updateBranch(
      request: zio.aws.amplify.model.UpdateBranchRequest
  ): IO[AwsError, zio.aws.amplify.model.UpdateBranchResponse.ReadOnly]
  def tagResource(
      request: zio.aws.amplify.model.TagResourceRequest
  ): IO[AwsError, zio.aws.amplify.model.TagResourceResponse.ReadOnly]
  def generateAccessLogs(
      request: zio.aws.amplify.model.GenerateAccessLogsRequest
  ): IO[AwsError, zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly]
  def deleteDomainAssociation(
      request: zio.aws.amplify.model.DeleteDomainAssociationRequest
  ): IO[
    AwsError,
    zio.aws.amplify.model.DeleteDomainAssociationResponse.ReadOnly
  ]
  def getDomainAssociation(
      request: zio.aws.amplify.model.GetDomainAssociationRequest
  ): IO[AwsError, zio.aws.amplify.model.GetDomainAssociationResponse.ReadOnly]
  def startDeployment(
      request: zio.aws.amplify.model.StartDeploymentRequest
  ): IO[AwsError, zio.aws.amplify.model.StartDeploymentResponse.ReadOnly]
  def deleteJob(
      request: zio.aws.amplify.model.DeleteJobRequest
  ): IO[AwsError, zio.aws.amplify.model.DeleteJobResponse.ReadOnly]
  def getBackendEnvironment(
      request: zio.aws.amplify.model.GetBackendEnvironmentRequest
  ): IO[AwsError, zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly]
}
object Amplify {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Amplify] = customized(
    identity
  )
  def customized(
      customization: AmplifyAsyncClientBuilder => AmplifyAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Amplify] = managed(
    customization
  ).toLayer
  def managed(
      customization: AmplifyAsyncClientBuilder => AmplifyAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Amplify] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AmplifyAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AmplifyAsyncClient, AmplifyAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[AmplifyAsyncClient, AmplifyAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new AmplifyImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AmplifyImpl[R](
      override val api: AmplifyAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Amplify
      with AwsServiceBase[R] {
    override val serviceName: String = "Amplify"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AmplifyImpl[R1] = new AmplifyImpl(api, newAspect, r)
    def getWebhook(
        request: zio.aws.amplify.model.GetWebhookRequest
    ): IO[AwsError, zio.aws.amplify.model.GetWebhookResponse.ReadOnly] =
      asyncRequestResponse[GetWebhookRequest, GetWebhookResponse](
        "getWebhook",
        api.getWebhook
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.GetWebhookResponse.wrap)
        .provideEnvironment(r)
    def getArtifactUrl(
        request: zio.aws.amplify.model.GetArtifactUrlRequest
    ): IO[AwsError, zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly] =
      asyncRequestResponse[GetArtifactUrlRequest, GetArtifactUrlResponse](
        "getArtifactUrl",
        api.getArtifactUrl
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.GetArtifactUrlResponse.wrap)
        .provideEnvironment(r)
    def getApp(
        request: zio.aws.amplify.model.GetAppRequest
    ): IO[AwsError, zio.aws.amplify.model.GetAppResponse.ReadOnly] =
      asyncRequestResponse[GetAppRequest, GetAppResponse]("getApp", api.getApp)(
        request.buildAwsValue()
      ).map(zio.aws.amplify.model.GetAppResponse.wrap).provideEnvironment(r)
    def deleteBackendEnvironment(
        request: zio.aws.amplify.model.DeleteBackendEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteBackendEnvironmentRequest,
      DeleteBackendEnvironmentResponse
    ]("deleteBackendEnvironment", api.deleteBackendEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.DeleteBackendEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listWebhooks(
        request: zio.aws.amplify.model.ListWebhooksRequest
    ): IO[AwsError, zio.aws.amplify.model.ListWebhooksResponse.ReadOnly] =
      asyncRequestResponse[ListWebhooksRequest, ListWebhooksResponse](
        "listWebhooks",
        api.listWebhooks
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.ListWebhooksResponse.wrap)
        .provideEnvironment(r)
    def startJob(
        request: zio.aws.amplify.model.StartJobRequest
    ): IO[AwsError, zio.aws.amplify.model.StartJobResponse.ReadOnly] =
      asyncRequestResponse[StartJobRequest, StartJobResponse](
        "startJob",
        api.startJob
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.StartJobResponse.wrap)
        .provideEnvironment(r)
    def listApps(
        request: zio.aws.amplify.model.ListAppsRequest
    ): IO[AwsError, zio.aws.amplify.model.ListAppsResponse.ReadOnly] =
      asyncRequestResponse[ListAppsRequest, ListAppsResponse](
        "listApps",
        api.listApps
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.ListAppsResponse.wrap)
        .provideEnvironment(r)
    def deleteBranch(
        request: zio.aws.amplify.model.DeleteBranchRequest
    ): IO[AwsError, zio.aws.amplify.model.DeleteBranchResponse.ReadOnly] =
      asyncRequestResponse[DeleteBranchRequest, DeleteBranchResponse](
        "deleteBranch",
        api.deleteBranch
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.DeleteBranchResponse.wrap)
        .provideEnvironment(r)
    def deleteWebhook(
        request: zio.aws.amplify.model.DeleteWebhookRequest
    ): IO[AwsError, zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly] =
      asyncRequestResponse[DeleteWebhookRequest, DeleteWebhookResponse](
        "deleteWebhook",
        api.deleteWebhook
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.DeleteWebhookResponse.wrap)
        .provideEnvironment(r)
    def stopJob(
        request: zio.aws.amplify.model.StopJobRequest
    ): IO[AwsError, zio.aws.amplify.model.StopJobResponse.ReadOnly] =
      asyncRequestResponse[StopJobRequest, StopJobResponse](
        "stopJob",
        api.stopJob
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.StopJobResponse.wrap)
        .provideEnvironment(r)
    def updateApp(
        request: zio.aws.amplify.model.UpdateAppRequest
    ): IO[AwsError, zio.aws.amplify.model.UpdateAppResponse.ReadOnly] =
      asyncRequestResponse[UpdateAppRequest, UpdateAppResponse](
        "updateApp",
        api.updateApp
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.UpdateAppResponse.wrap)
        .provideEnvironment(r)
    def createApp(
        request: zio.aws.amplify.model.CreateAppRequest
    ): IO[AwsError, zio.aws.amplify.model.CreateAppResponse.ReadOnly] =
      asyncRequestResponse[CreateAppRequest, CreateAppResponse](
        "createApp",
        api.createApp
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.CreateAppResponse.wrap)
        .provideEnvironment(r)
    def updateWebhook(
        request: zio.aws.amplify.model.UpdateWebhookRequest
    ): IO[AwsError, zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly] =
      asyncRequestResponse[UpdateWebhookRequest, UpdateWebhookResponse](
        "updateWebhook",
        api.updateWebhook
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.UpdateWebhookResponse.wrap)
        .provideEnvironment(r)
    def createBranch(
        request: zio.aws.amplify.model.CreateBranchRequest
    ): IO[AwsError, zio.aws.amplify.model.CreateBranchResponse.ReadOnly] =
      asyncRequestResponse[CreateBranchRequest, CreateBranchResponse](
        "createBranch",
        api.createBranch
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.CreateBranchResponse.wrap)
        .provideEnvironment(r)
    def updateDomainAssociation(
        request: zio.aws.amplify.model.UpdateDomainAssociationRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.UpdateDomainAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDomainAssociationRequest,
      UpdateDomainAssociationResponse
    ]("updateDomainAssociation", api.updateDomainAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.UpdateDomainAssociationResponse.wrap)
      .provideEnvironment(r)
    def deleteApp(
        request: zio.aws.amplify.model.DeleteAppRequest
    ): IO[AwsError, zio.aws.amplify.model.DeleteAppResponse.ReadOnly] =
      asyncRequestResponse[DeleteAppRequest, DeleteAppResponse](
        "deleteApp",
        api.deleteApp
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.DeleteAppResponse.wrap)
        .provideEnvironment(r)
    def listArtifacts(
        request: zio.aws.amplify.model.ListArtifactsRequest
    ): IO[AwsError, zio.aws.amplify.model.ListArtifactsResponse.ReadOnly] =
      asyncRequestResponse[ListArtifactsRequest, ListArtifactsResponse](
        "listArtifacts",
        api.listArtifacts
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.ListArtifactsResponse.wrap)
        .provideEnvironment(r)
    def listBranches(
        request: zio.aws.amplify.model.ListBranchesRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListBranchesRequest, ListBranchesResponse](
        "listBranches",
        api.listBranches
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.ListBranchesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.amplify.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.amplify.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createDeployment(
        request: zio.aws.amplify.model.CreateDeploymentRequest
    ): IO[AwsError, zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly] =
      asyncRequestResponse[CreateDeploymentRequest, CreateDeploymentResponse](
        "createDeployment",
        api.createDeployment
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.CreateDeploymentResponse.wrap)
        .provideEnvironment(r)
    def getJob(
        request: zio.aws.amplify.model.GetJobRequest
    ): IO[AwsError, zio.aws.amplify.model.GetJobResponse.ReadOnly] =
      asyncRequestResponse[GetJobRequest, GetJobResponse]("getJob", api.getJob)(
        request.buildAwsValue()
      ).map(zio.aws.amplify.model.GetJobResponse.wrap).provideEnvironment(r)
    def createBackendEnvironment(
        request: zio.aws.amplify.model.CreateBackendEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.CreateBackendEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateBackendEnvironmentRequest,
      CreateBackendEnvironmentResponse
    ]("createBackendEnvironment", api.createBackendEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.CreateBackendEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listBackendEnvironments(
        request: zio.aws.amplify.model.ListBackendEnvironmentsRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListBackendEnvironmentsRequest,
      ListBackendEnvironmentsResponse
    ]("listBackendEnvironments", api.listBackendEnvironments)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.ListBackendEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def createDomainAssociation(
        request: zio.aws.amplify.model.CreateDomainAssociationRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.CreateDomainAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDomainAssociationRequest,
      CreateDomainAssociationResponse
    ]("createDomainAssociation", api.createDomainAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.CreateDomainAssociationResponse.wrap)
      .provideEnvironment(r)
    def getBranch(
        request: zio.aws.amplify.model.GetBranchRequest
    ): IO[AwsError, zio.aws.amplify.model.GetBranchResponse.ReadOnly] =
      asyncRequestResponse[GetBranchRequest, GetBranchResponse](
        "getBranch",
        api.getBranch
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.GetBranchResponse.wrap)
        .provideEnvironment(r)
    def listDomainAssociations(
        request: zio.aws.amplify.model.ListDomainAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDomainAssociationsRequest,
      ListDomainAssociationsResponse
    ]("listDomainAssociations", api.listDomainAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.ListDomainAssociationsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.amplify.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.amplify.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listJobs(
        request: zio.aws.amplify.model.ListJobsRequest
    ): IO[AwsError, zio.aws.amplify.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def createWebhook(
        request: zio.aws.amplify.model.CreateWebhookRequest
    ): IO[AwsError, zio.aws.amplify.model.CreateWebhookResponse.ReadOnly] =
      asyncRequestResponse[CreateWebhookRequest, CreateWebhookResponse](
        "createWebhook",
        api.createWebhook
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.CreateWebhookResponse.wrap)
        .provideEnvironment(r)
    def updateBranch(
        request: zio.aws.amplify.model.UpdateBranchRequest
    ): IO[AwsError, zio.aws.amplify.model.UpdateBranchResponse.ReadOnly] =
      asyncRequestResponse[UpdateBranchRequest, UpdateBranchResponse](
        "updateBranch",
        api.updateBranch
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.UpdateBranchResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.amplify.model.TagResourceRequest
    ): IO[AwsError, zio.aws.amplify.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def generateAccessLogs(
        request: zio.aws.amplify.model.GenerateAccessLogsRequest
    ): IO[AwsError, zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly] =
      asyncRequestResponse[
        GenerateAccessLogsRequest,
        GenerateAccessLogsResponse
      ]("generateAccessLogs", api.generateAccessLogs)(request.buildAwsValue())
        .map(zio.aws.amplify.model.GenerateAccessLogsResponse.wrap)
        .provideEnvironment(r)
    def deleteDomainAssociation(
        request: zio.aws.amplify.model.DeleteDomainAssociationRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.DeleteDomainAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDomainAssociationRequest,
      DeleteDomainAssociationResponse
    ]("deleteDomainAssociation", api.deleteDomainAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.DeleteDomainAssociationResponse.wrap)
      .provideEnvironment(r)
    def getDomainAssociation(
        request: zio.aws.amplify.model.GetDomainAssociationRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.GetDomainAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainAssociationRequest,
      GetDomainAssociationResponse
    ]("getDomainAssociation", api.getDomainAssociation)(request.buildAwsValue())
      .map(zio.aws.amplify.model.GetDomainAssociationResponse.wrap)
      .provideEnvironment(r)
    def startDeployment(
        request: zio.aws.amplify.model.StartDeploymentRequest
    ): IO[AwsError, zio.aws.amplify.model.StartDeploymentResponse.ReadOnly] =
      asyncRequestResponse[StartDeploymentRequest, StartDeploymentResponse](
        "startDeployment",
        api.startDeployment
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.StartDeploymentResponse.wrap)
        .provideEnvironment(r)
    def deleteJob(
        request: zio.aws.amplify.model.DeleteJobRequest
    ): IO[AwsError, zio.aws.amplify.model.DeleteJobResponse.ReadOnly] =
      asyncRequestResponse[DeleteJobRequest, DeleteJobResponse](
        "deleteJob",
        api.deleteJob
      )(request.buildAwsValue())
        .map(zio.aws.amplify.model.DeleteJobResponse.wrap)
        .provideEnvironment(r)
    def getBackendEnvironment(
        request: zio.aws.amplify.model.GetBackendEnvironmentRequest
    ): IO[
      AwsError,
      zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBackendEnvironmentRequest,
      GetBackendEnvironmentResponse
    ]("getBackendEnvironment", api.getBackendEnvironment)(
      request.buildAwsValue()
    ).map(zio.aws.amplify.model.GetBackendEnvironmentResponse.wrap)
      .provideEnvironment(r)
  }
  def getWebhook(request: zio.aws.amplify.model.GetWebhookRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWebhook(request))
  def getArtifactUrl(request: zio.aws.amplify.model.GetArtifactUrlRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getArtifactUrl(request))
  def getApp(request: zio.aws.amplify.model.GetAppRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApp(request))
  def deleteBackendEnvironment(
      request: zio.aws.amplify.model.DeleteBackendEnvironmentRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackendEnvironment(request))
  def listWebhooks(request: zio.aws.amplify.model.ListWebhooksRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListWebhooksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWebhooks(request))
  def startJob(request: zio.aws.amplify.model.StartJobRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.StartJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startJob(request))
  def listApps(request: zio.aws.amplify.model.ListAppsRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListAppsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApps(request))
  def deleteBranch(request: zio.aws.amplify.model.DeleteBranchRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBranch(request))
  def deleteWebhook(request: zio.aws.amplify.model.DeleteWebhookRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWebhook(request))
  def stopJob(request: zio.aws.amplify.model.StopJobRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.StopJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopJob(request))
  def updateApp(request: zio.aws.amplify.model.UpdateAppRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.UpdateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApp(request))
  def createApp(request: zio.aws.amplify.model.CreateAppRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApp(request))
  def updateWebhook(request: zio.aws.amplify.model.UpdateWebhookRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWebhook(request))
  def createBranch(request: zio.aws.amplify.model.CreateBranchRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBranch(request))
  def updateDomainAssociation(
      request: zio.aws.amplify.model.UpdateDomainAssociationRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.UpdateDomainAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDomainAssociation(request))
  def deleteApp(request: zio.aws.amplify.model.DeleteAppRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteAppResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApp(request))
  def listArtifacts(request: zio.aws.amplify.model.ListArtifactsRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListArtifactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listArtifacts(request))
  def listBranches(
      request: zio.aws.amplify.model.ListBranchesRequest
  ): ZIO[zio.aws.amplify.Amplify, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listBranches(request))
  def untagResource(request: zio.aws.amplify.model.UntagResourceRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createDeployment(
      request: zio.aws.amplify.model.CreateDeploymentRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeployment(request))
  def getJob(request: zio.aws.amplify.model.GetJobRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJob(request))
  def createBackendEnvironment(
      request: zio.aws.amplify.model.CreateBackendEnvironmentRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateBackendEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackendEnvironment(request))
  def listBackendEnvironments(
      request: zio.aws.amplify.model.ListBackendEnvironmentsRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListBackendEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackendEnvironments(request))
  def createDomainAssociation(
      request: zio.aws.amplify.model.CreateDomainAssociationRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateDomainAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomainAssociation(request))
  def getBranch(request: zio.aws.amplify.model.GetBranchRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBranch(request))
  def listDomainAssociations(
      request: zio.aws.amplify.model.ListDomainAssociationsRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListDomainAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainAssociations(request))
  def listTagsForResource(
      request: zio.aws.amplify.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listJobs(request: zio.aws.amplify.model.ListJobsRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobs(request))
  def createWebhook(request: zio.aws.amplify.model.CreateWebhookRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.CreateWebhookResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWebhook(request))
  def updateBranch(request: zio.aws.amplify.model.UpdateBranchRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.UpdateBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBranch(request))
  def tagResource(request: zio.aws.amplify.model.TagResourceRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def generateAccessLogs(
      request: zio.aws.amplify.model.GenerateAccessLogsRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GenerateAccessLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateAccessLogs(request))
  def deleteDomainAssociation(
      request: zio.aws.amplify.model.DeleteDomainAssociationRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteDomainAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDomainAssociation(request))
  def getDomainAssociation(
      request: zio.aws.amplify.model.GetDomainAssociationRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetDomainAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainAssociation(request))
  def startDeployment(
      request: zio.aws.amplify.model.StartDeploymentRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.StartDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeployment(request))
  def deleteJob(request: zio.aws.amplify.model.DeleteJobRequest): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.DeleteJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteJob(request))
  def getBackendEnvironment(
      request: zio.aws.amplify.model.GetBackendEnvironmentRequest
  ): ZIO[
    zio.aws.amplify.Amplify,
    AwsError,
    zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackendEnvironment(request))
}
