package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  UpdateTime,
  CustomHeaders,
  DefaultDomain,
  BuildSpec,
  EnableAutoBranchCreation,
  CreateTime,
  AppArn,
  Repository,
  BasicAuthCredentials,
  TagValue,
  EnableBranchAutoBuild,
  ServiceRoleArn,
  Description,
  AutoBranchCreationPattern,
  AppId,
  EnvValue,
  EnvKey,
  EnableBranchAutoDeletion,
  Name,
  TagKey
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class App(
    appId: AppId,
    appArn: AppArn,
    name: Name,
    tags: Option[Map[TagKey, TagValue]] = None,
    description: Description,
    repository: Repository,
    platform: zio.aws.amplify.model.Platform,
    createTime: CreateTime,
    updateTime: UpdateTime,
    iamServiceRoleArn: Option[ServiceRoleArn] = None,
    environmentVariables: Map[EnvKey, EnvValue],
    defaultDomain: DefaultDomain,
    enableBranchAutoBuild: EnableBranchAutoBuild,
    enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] = None,
    enableBasicAuth: EnableBasicAuth,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    customRules: Option[Iterable[zio.aws.amplify.model.CustomRule]] = None,
    productionBranch: Option[zio.aws.amplify.model.ProductionBranch] = None,
    buildSpec: Option[BuildSpec] = None,
    customHeaders: Option[CustomHeaders] = None,
    enableAutoBranchCreation: Option[EnableAutoBranchCreation] = None,
    autoBranchCreationPatterns: Option[Iterable[AutoBranchCreationPattern]] =
      None,
    autoBranchCreationConfig: Option[
      zio.aws.amplify.model.AutoBranchCreationConfig
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.amplify.model.App = {
    import App.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.App
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .appArn(AppArn.unwrap(appArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .description(Description.unwrap(description): java.lang.String)
      .repository(Repository.unwrap(repository): java.lang.String)
      .platform(platform.unwrap)
      .createTime(CreateTime.unwrap(createTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .optionallyWith(
        iamServiceRoleArn.map(value =>
          ServiceRoleArn.unwrap(value): java.lang.String
        )
      )(_.iamServiceRoleArn)
      .environmentVariables(
        environmentVariables
          .map({ case (key, value) =>
            (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .defaultDomain(DefaultDomain.unwrap(defaultDomain): java.lang.String)
      .enableBranchAutoBuild(
        EnableBranchAutoBuild.unwrap(enableBranchAutoBuild): java.lang.Boolean
      )
      .optionallyWith(
        enableBranchAutoDeletion.map(value =>
          EnableBranchAutoDeletion.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoDeletion)
      .enableBasicAuth(
        EnableBasicAuth.unwrap(enableBasicAuth): java.lang.Boolean
      )
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        customRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customRules)
      .optionallyWith(productionBranch.map(value => value.buildAwsValue()))(
        _.productionBranch
      )
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        customHeaders.map(value =>
          CustomHeaders.unwrap(value): java.lang.String
        )
      )(_.customHeaders)
      .optionallyWith(
        enableAutoBranchCreation.map(value =>
          EnableAutoBranchCreation.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBranchCreation)
      .optionallyWith(
        autoBranchCreationPatterns.map(value =>
          value.map { item =>
            AutoBranchCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoBranchCreationPatterns)
      .optionallyWith(
        autoBranchCreationConfig.map(value => value.buildAwsValue())
      )(_.autoBranchCreationConfig)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.App.ReadOnly =
    zio.aws.amplify.model.App.wrap(buildAwsValue())
}
object App {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.App] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.App = zio.aws.amplify.model.App(
      appId,
      appArn,
      name,
      tags.map(value => value),
      description,
      repository,
      platform,
      createTime,
      updateTime,
      iamServiceRoleArn.map(value => value),
      environmentVariables,
      defaultDomain,
      enableBranchAutoBuild,
      enableBranchAutoDeletion.map(value => value),
      enableBasicAuth,
      basicAuthCredentials.map(value => value),
      customRules.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      productionBranch.map(value => value.asEditable),
      buildSpec.map(value => value),
      customHeaders.map(value => value),
      enableAutoBranchCreation.map(value => value),
      autoBranchCreationPatterns.map(value => value),
      autoBranchCreationConfig.map(value => value.asEditable)
    )
    def appId: AppId
    def appArn: AppArn
    def name: Name
    def tags: Option[Map[TagKey, TagValue]]
    def description: Description
    def repository: Repository
    def platform: zio.aws.amplify.model.Platform
    def createTime: CreateTime
    def updateTime: UpdateTime
    def iamServiceRoleArn: Option[ServiceRoleArn]
    def environmentVariables: Map[EnvKey, EnvValue]
    def defaultDomain: DefaultDomain
    def enableBranchAutoBuild: EnableBranchAutoBuild
    def enableBranchAutoDeletion: Option[EnableBranchAutoDeletion]
    def enableBasicAuth: EnableBasicAuth
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def customRules: Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]]
    def productionBranch
        : Option[zio.aws.amplify.model.ProductionBranch.ReadOnly]
    def buildSpec: Option[BuildSpec]
    def customHeaders: Option[CustomHeaders]
    def enableAutoBranchCreation: Option[EnableAutoBranchCreation]
    def autoBranchCreationPatterns: Option[List[AutoBranchCreationPattern]]
    def autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getAppArn: ZIO[Any, Nothing, AppArn] = ZIO.succeed(appArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getRepository: ZIO[Any, Nothing, Repository] = ZIO.succeed(repository)
    def getPlatform: ZIO[Any, Nothing, zio.aws.amplify.model.Platform] =
      ZIO.succeed(platform)
    def getCreateTime: ZIO[Any, Nothing, CreateTime] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getIamServiceRoleArn: ZIO[Any, AwsError, ServiceRoleArn] =
      AwsError.unwrapOptionField("iamServiceRoleArn", iamServiceRoleArn)
    def getEnvironmentVariables: ZIO[Any, Nothing, Map[EnvKey, EnvValue]] =
      ZIO.succeed(environmentVariables)
    def getDefaultDomain: ZIO[Any, Nothing, DefaultDomain] =
      ZIO.succeed(defaultDomain)
    def getEnableBranchAutoBuild: ZIO[Any, Nothing, EnableBranchAutoBuild] =
      ZIO.succeed(enableBranchAutoBuild)
    def getEnableBranchAutoDeletion
        : ZIO[Any, AwsError, EnableBranchAutoDeletion] = AwsError
      .unwrapOptionField("enableBranchAutoDeletion", enableBranchAutoDeletion)
    def getEnableBasicAuth: ZIO[Any, Nothing, EnableBasicAuth] =
      ZIO.succeed(enableBasicAuth)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getCustomRules
        : ZIO[Any, AwsError, List[zio.aws.amplify.model.CustomRule.ReadOnly]] =
      AwsError.unwrapOptionField("customRules", customRules)
    def getProductionBranch
        : ZIO[Any, AwsError, zio.aws.amplify.model.ProductionBranch.ReadOnly] =
      AwsError.unwrapOptionField("productionBranch", productionBranch)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getCustomHeaders: ZIO[Any, AwsError, CustomHeaders] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getEnableAutoBranchCreation
        : ZIO[Any, AwsError, EnableAutoBranchCreation] = AwsError
      .unwrapOptionField("enableAutoBranchCreation", enableAutoBranchCreation)
    def getAutoBranchCreationPatterns
        : ZIO[Any, AwsError, List[AutoBranchCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoBranchCreationPatterns",
        autoBranchCreationPatterns
      )
    def getAutoBranchCreationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoBranchCreationConfig",
      autoBranchCreationConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.App
  ) extends zio.aws.amplify.model.App.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val appArn: AppArn =
      zio.aws.amplify.model.primitives.AppArn(impl.appArn())
    override val name: Name = zio.aws.amplify.model.primitives.Name(impl.name())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .TagKey(key) -> zio.aws.amplify.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val description: Description =
      zio.aws.amplify.model.primitives.Description(impl.description())
    override val repository: Repository =
      zio.aws.amplify.model.primitives.Repository(impl.repository())
    override val platform: zio.aws.amplify.model.Platform =
      zio.aws.amplify.model.Platform.wrap(impl.platform())
    override val createTime: CreateTime =
      zio.aws.amplify.model.primitives.CreateTime(impl.createTime())
    override val updateTime: UpdateTime =
      zio.aws.amplify.model.primitives.UpdateTime(impl.updateTime())
    override val iamServiceRoleArn: Option[ServiceRoleArn] = scala
      .Option(impl.iamServiceRoleArn())
      .map(value => zio.aws.amplify.model.primitives.ServiceRoleArn(value))
    override val environmentVariables: Map[EnvKey, EnvValue] = impl
      .environmentVariables()
      .asScala
      .map({ case (key, value) =>
        zio.aws.amplify.model.primitives
          .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
      })
      .toMap
    override val defaultDomain: DefaultDomain =
      zio.aws.amplify.model.primitives.DefaultDomain(impl.defaultDomain())
    override val enableBranchAutoBuild: EnableBranchAutoBuild =
      zio.aws.amplify.model.primitives
        .EnableBranchAutoBuild(impl.enableBranchAutoBuild())
    override val enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] =
      scala
        .Option(impl.enableBranchAutoDeletion())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableBranchAutoDeletion(value)
        )
    override val enableBasicAuth: EnableBasicAuth =
      zio.aws.amplify.model.primitives.EnableBasicAuth(impl.enableBasicAuth())
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val customRules
        : Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]] = scala
      .Option(impl.customRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.CustomRule.wrap(item)
        }.toList
      )
    override val productionBranch
        : Option[zio.aws.amplify.model.ProductionBranch.ReadOnly] = scala
      .Option(impl.productionBranch())
      .map(value => zio.aws.amplify.model.ProductionBranch.wrap(value))
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val customHeaders: Option[CustomHeaders] = scala
      .Option(impl.customHeaders())
      .map(value => zio.aws.amplify.model.primitives.CustomHeaders(value))
    override val enableAutoBranchCreation: Option[EnableAutoBranchCreation] =
      scala
        .Option(impl.enableAutoBranchCreation())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableAutoBranchCreation(value)
        )
    override val autoBranchCreationPatterns
        : Option[List[AutoBranchCreationPattern]] = scala
      .Option(impl.autoBranchCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoBranchCreationPattern(item)
        }.toList
      )
    override val autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly] =
      scala
        .Option(impl.autoBranchCreationConfig())
        .map(value =>
          zio.aws.amplify.model.AutoBranchCreationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.App
  ): zio.aws.amplify.model.App.ReadOnly = new Wrapper(impl)
}
