package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableNotification,
  EnableAutoBuild,
  DisplayName,
  PullRequestEnvironmentName,
  UpdateTime,
  TTL,
  BuildSpec,
  CreateTime,
  ActiveJobId,
  EnablePullRequestPreview,
  BasicAuthCredentials,
  TagValue,
  AssociatedResource,
  ThumbnailUrl,
  Description,
  TotalNumberOfJobs,
  EnablePerformanceMode,
  EnvValue,
  BranchArn,
  EnvKey,
  BackendEnvironmentArn,
  Framework,
  BranchName,
  TagKey,
  CustomDomain
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Branch(
    branchArn: BranchArn,
    branchName: BranchName,
    description: Description,
    tags: Option[Map[TagKey, TagValue]] = None,
    stage: zio.aws.amplify.model.Stage,
    displayName: DisplayName,
    enableNotification: EnableNotification,
    createTime: CreateTime,
    updateTime: UpdateTime,
    environmentVariables: Map[EnvKey, EnvValue],
    enableAutoBuild: EnableAutoBuild,
    customDomains: Iterable[CustomDomain],
    framework: Framework,
    activeJobId: ActiveJobId,
    totalNumberOfJobs: TotalNumberOfJobs,
    enableBasicAuth: EnableBasicAuth,
    enablePerformanceMode: Option[EnablePerformanceMode] = None,
    thumbnailUrl: Option[ThumbnailUrl] = None,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    buildSpec: Option[BuildSpec] = None,
    ttl: TTL,
    associatedResources: Option[Iterable[AssociatedResource]] = None,
    enablePullRequestPreview: EnablePullRequestPreview,
    pullRequestEnvironmentName: Option[PullRequestEnvironmentName] = None,
    destinationBranch: Option[BranchName] = None,
    sourceBranch: Option[BranchName] = None,
    backendEnvironmentArn: Option[BackendEnvironmentArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.amplify.model.Branch = {
    import Branch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.Branch
      .builder()
      .branchArn(BranchArn.unwrap(branchArn): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .description(Description.unwrap(description): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .stage(stage.unwrap)
      .displayName(DisplayName.unwrap(displayName): java.lang.String)
      .enableNotification(
        EnableNotification.unwrap(enableNotification): java.lang.Boolean
      )
      .createTime(CreateTime.unwrap(createTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .environmentVariables(
        environmentVariables
          .map({ case (key, value) =>
            (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
              value
            ): java.lang.String)
          })
          .asJava
      )
      .enableAutoBuild(
        EnableAutoBuild.unwrap(enableAutoBuild): java.lang.Boolean
      )
      .customDomains(customDomains.map { item =>
        CustomDomain.unwrap(item): java.lang.String
      }.asJavaCollection)
      .framework(Framework.unwrap(framework): java.lang.String)
      .activeJobId(ActiveJobId.unwrap(activeJobId): java.lang.String)
      .totalNumberOfJobs(
        TotalNumberOfJobs.unwrap(totalNumberOfJobs): java.lang.String
      )
      .enableBasicAuth(
        EnableBasicAuth.unwrap(enableBasicAuth): java.lang.Boolean
      )
      .optionallyWith(
        enablePerformanceMode.map(value =>
          EnablePerformanceMode.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceMode)
      .optionallyWith(
        thumbnailUrl.map(value => ThumbnailUrl.unwrap(value): java.lang.String)
      )(_.thumbnailUrl)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .ttl(TTL.unwrap(ttl): java.lang.String)
      .optionallyWith(
        associatedResources.map(value =>
          value.map { item =>
            AssociatedResource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedResources)
      .enablePullRequestPreview(
        EnablePullRequestPreview.unwrap(
          enablePullRequestPreview
        ): java.lang.Boolean
      )
      .optionallyWith(
        pullRequestEnvironmentName.map(value =>
          PullRequestEnvironmentName.unwrap(value): java.lang.String
        )
      )(_.pullRequestEnvironmentName)
      .optionallyWith(
        destinationBranch.map(value =>
          BranchName.unwrap(value): java.lang.String
        )
      )(_.destinationBranch)
      .optionallyWith(
        sourceBranch.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.sourceBranch)
      .optionallyWith(
        backendEnvironmentArn.map(value =>
          BackendEnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentArn)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.Branch.ReadOnly =
    zio.aws.amplify.model.Branch.wrap(buildAwsValue())
}
object Branch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.Branch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.Branch = zio.aws.amplify.model.Branch(
      branchArn,
      branchName,
      description,
      tags.map(value => value),
      stage,
      displayName,
      enableNotification,
      createTime,
      updateTime,
      environmentVariables,
      enableAutoBuild,
      customDomains,
      framework,
      activeJobId,
      totalNumberOfJobs,
      enableBasicAuth,
      enablePerformanceMode.map(value => value),
      thumbnailUrl.map(value => value),
      basicAuthCredentials.map(value => value),
      buildSpec.map(value => value),
      ttl,
      associatedResources.map(value => value),
      enablePullRequestPreview,
      pullRequestEnvironmentName.map(value => value),
      destinationBranch.map(value => value),
      sourceBranch.map(value => value),
      backendEnvironmentArn.map(value => value)
    )
    def branchArn: BranchArn
    def branchName: BranchName
    def description: Description
    def tags: Option[Map[TagKey, TagValue]]
    def stage: zio.aws.amplify.model.Stage
    def displayName: DisplayName
    def enableNotification: EnableNotification
    def createTime: CreateTime
    def updateTime: UpdateTime
    def environmentVariables: Map[EnvKey, EnvValue]
    def enableAutoBuild: EnableAutoBuild
    def customDomains: List[CustomDomain]
    def framework: Framework
    def activeJobId: ActiveJobId
    def totalNumberOfJobs: TotalNumberOfJobs
    def enableBasicAuth: EnableBasicAuth
    def enablePerformanceMode: Option[EnablePerformanceMode]
    def thumbnailUrl: Option[ThumbnailUrl]
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def buildSpec: Option[BuildSpec]
    def ttl: TTL
    def associatedResources: Option[List[AssociatedResource]]
    def enablePullRequestPreview: EnablePullRequestPreview
    def pullRequestEnvironmentName: Option[PullRequestEnvironmentName]
    def destinationBranch: Option[BranchName]
    def sourceBranch: Option[BranchName]
    def backendEnvironmentArn: Option[BackendEnvironmentArn]
    def getBranchArn: ZIO[Any, Nothing, BranchArn] = ZIO.succeed(branchArn)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStage: ZIO[Any, Nothing, zio.aws.amplify.model.Stage] =
      ZIO.succeed(stage)
    def getDisplayName: ZIO[Any, Nothing, DisplayName] =
      ZIO.succeed(displayName)
    def getEnableNotification: ZIO[Any, Nothing, EnableNotification] =
      ZIO.succeed(enableNotification)
    def getCreateTime: ZIO[Any, Nothing, CreateTime] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getEnvironmentVariables: ZIO[Any, Nothing, Map[EnvKey, EnvValue]] =
      ZIO.succeed(environmentVariables)
    def getEnableAutoBuild: ZIO[Any, Nothing, EnableAutoBuild] =
      ZIO.succeed(enableAutoBuild)
    def getCustomDomains: ZIO[Any, Nothing, List[CustomDomain]] =
      ZIO.succeed(customDomains)
    def getFramework: ZIO[Any, Nothing, Framework] = ZIO.succeed(framework)
    def getActiveJobId: ZIO[Any, Nothing, ActiveJobId] =
      ZIO.succeed(activeJobId)
    def getTotalNumberOfJobs: ZIO[Any, Nothing, TotalNumberOfJobs] =
      ZIO.succeed(totalNumberOfJobs)
    def getEnableBasicAuth: ZIO[Any, Nothing, EnableBasicAuth] =
      ZIO.succeed(enableBasicAuth)
    def getEnablePerformanceMode: ZIO[Any, AwsError, EnablePerformanceMode] =
      AwsError.unwrapOptionField("enablePerformanceMode", enablePerformanceMode)
    def getThumbnailUrl: ZIO[Any, AwsError, ThumbnailUrl] =
      AwsError.unwrapOptionField("thumbnailUrl", thumbnailUrl)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getTtl: ZIO[Any, Nothing, TTL] = ZIO.succeed(ttl)
    def getAssociatedResources: ZIO[Any, AwsError, List[AssociatedResource]] =
      AwsError.unwrapOptionField("associatedResources", associatedResources)
    def getEnablePullRequestPreview
        : ZIO[Any, Nothing, EnablePullRequestPreview] =
      ZIO.succeed(enablePullRequestPreview)
    def getPullRequestEnvironmentName
        : ZIO[Any, AwsError, PullRequestEnvironmentName] =
      AwsError.unwrapOptionField(
        "pullRequestEnvironmentName",
        pullRequestEnvironmentName
      )
    def getDestinationBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("destinationBranch", destinationBranch)
    def getSourceBranch: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("sourceBranch", sourceBranch)
    def getBackendEnvironmentArn: ZIO[Any, AwsError, BackendEnvironmentArn] =
      AwsError.unwrapOptionField("backendEnvironmentArn", backendEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.Branch
  ) extends zio.aws.amplify.model.Branch.ReadOnly {
    override val branchArn: BranchArn =
      zio.aws.amplify.model.primitives.BranchArn(impl.branchArn())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val description: Description =
      zio.aws.amplify.model.primitives.Description(impl.description())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .TagKey(key) -> zio.aws.amplify.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val stage: zio.aws.amplify.model.Stage =
      zio.aws.amplify.model.Stage.wrap(impl.stage())
    override val displayName: DisplayName =
      zio.aws.amplify.model.primitives.DisplayName(impl.displayName())
    override val enableNotification: EnableNotification =
      zio.aws.amplify.model.primitives
        .EnableNotification(impl.enableNotification())
    override val createTime: CreateTime =
      zio.aws.amplify.model.primitives.CreateTime(impl.createTime())
    override val updateTime: UpdateTime =
      zio.aws.amplify.model.primitives.UpdateTime(impl.updateTime())
    override val environmentVariables: Map[EnvKey, EnvValue] = impl
      .environmentVariables()
      .asScala
      .map({ case (key, value) =>
        zio.aws.amplify.model.primitives
          .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
      })
      .toMap
    override val enableAutoBuild: EnableAutoBuild =
      zio.aws.amplify.model.primitives.EnableAutoBuild(impl.enableAutoBuild())
    override val customDomains: List[CustomDomain] = impl
      .customDomains()
      .asScala
      .map { item =>
        zio.aws.amplify.model.primitives.CustomDomain(item)
      }
      .toList
    override val framework: Framework =
      zio.aws.amplify.model.primitives.Framework(impl.framework())
    override val activeJobId: ActiveJobId =
      zio.aws.amplify.model.primitives.ActiveJobId(impl.activeJobId())
    override val totalNumberOfJobs: TotalNumberOfJobs =
      zio.aws.amplify.model.primitives
        .TotalNumberOfJobs(impl.totalNumberOfJobs())
    override val enableBasicAuth: EnableBasicAuth =
      zio.aws.amplify.model.primitives.EnableBasicAuth(impl.enableBasicAuth())
    override val enablePerformanceMode: Option[EnablePerformanceMode] = scala
      .Option(impl.enablePerformanceMode())
      .map(value =>
        zio.aws.amplify.model.primitives.EnablePerformanceMode(value)
      )
    override val thumbnailUrl: Option[ThumbnailUrl] = scala
      .Option(impl.thumbnailUrl())
      .map(value => zio.aws.amplify.model.primitives.ThumbnailUrl(value))
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val ttl: TTL = zio.aws.amplify.model.primitives.TTL(impl.ttl())
    override val associatedResources: Option[List[AssociatedResource]] = scala
      .Option(impl.associatedResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AssociatedResource(item)
        }.toList
      )
    override val enablePullRequestPreview: EnablePullRequestPreview =
      zio.aws.amplify.model.primitives
        .EnablePullRequestPreview(impl.enablePullRequestPreview())
    override val pullRequestEnvironmentName
        : Option[PullRequestEnvironmentName] = scala
      .Option(impl.pullRequestEnvironmentName())
      .map(value =>
        zio.aws.amplify.model.primitives.PullRequestEnvironmentName(value)
      )
    override val destinationBranch: Option[BranchName] = scala
      .Option(impl.destinationBranch())
      .map(value => zio.aws.amplify.model.primitives.BranchName(value))
    override val sourceBranch: Option[BranchName] = scala
      .Option(impl.sourceBranch())
      .map(value => zio.aws.amplify.model.primitives.BranchName(value))
    override val backendEnvironmentArn: Option[BackendEnvironmentArn] = scala
      .Option(impl.backendEnvironmentArn())
      .map(value =>
        zio.aws.amplify.model.primitives.BackendEnvironmentArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.Branch
  ): zio.aws.amplify.model.Branch.ReadOnly = new Wrapper(impl)
}
