package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  DomainName,
  AutoSubDomainIAMRole,
  AppId,
  EnableAutoSubDomain,
  AutoSubDomainCreationPattern
}
import scala.jdk.CollectionConverters.*
final case class CreateDomainAssociationRequest(
    appId: AppId,
    domainName: DomainName,
    enableAutoSubDomain: Option[EnableAutoSubDomain] = None,
    subDomainSettings: Iterable[zio.aws.amplify.model.SubDomainSetting],
    autoSubDomainCreationPatterns: Option[
      Iterable[AutoSubDomainCreationPattern]
    ] = None,
    autoSubDomainIAMRole: Option[AutoSubDomainIAMRole] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest = {
    import CreateDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        enableAutoSubDomain.map(value =>
          EnableAutoSubDomain.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoSubDomain)
      .subDomainSettings(subDomainSettings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        autoSubDomainCreationPatterns.map(value =>
          value.map { item =>
            AutoSubDomainCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoSubDomainCreationPatterns)
      .optionallyWith(
        autoSubDomainIAMRole.map(value =>
          AutoSubDomainIAMRole.unwrap(value): java.lang.String
        )
      )(_.autoSubDomainIAMRole)
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.CreateDomainAssociationRequest.ReadOnly =
    zio.aws.amplify.model.CreateDomainAssociationRequest.wrap(buildAwsValue())
}
object CreateDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateDomainAssociationRequest =
      zio.aws.amplify.model.CreateDomainAssociationRequest(
        appId,
        domainName,
        enableAutoSubDomain.map(value => value),
        subDomainSettings.map { item =>
          item.asEditable
        },
        autoSubDomainCreationPatterns.map(value => value),
        autoSubDomainIAMRole.map(value => value)
      )
    def appId: AppId
    def domainName: DomainName
    def enableAutoSubDomain: Option[EnableAutoSubDomain]
    def subDomainSettings: List[zio.aws.amplify.model.SubDomainSetting.ReadOnly]
    def autoSubDomainCreationPatterns
        : Option[List[AutoSubDomainCreationPattern]]
    def autoSubDomainIAMRole: Option[AutoSubDomainIAMRole]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getEnableAutoSubDomain: ZIO[Any, AwsError, EnableAutoSubDomain] =
      AwsError.unwrapOptionField("enableAutoSubDomain", enableAutoSubDomain)
    def getSubDomainSettings: ZIO[Any, Nothing, List[
      zio.aws.amplify.model.SubDomainSetting.ReadOnly
    ]] = ZIO.succeed(subDomainSettings)
    def getAutoSubDomainCreationPatterns
        : ZIO[Any, AwsError, List[AutoSubDomainCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoSubDomainCreationPatterns",
        autoSubDomainCreationPatterns
      )
    def getAutoSubDomainIAMRole: ZIO[Any, AwsError, AutoSubDomainIAMRole] =
      AwsError.unwrapOptionField("autoSubDomainIAMRole", autoSubDomainIAMRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest
  ) extends zio.aws.amplify.model.CreateDomainAssociationRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val domainName: DomainName =
      zio.aws.amplify.model.primitives.DomainName(impl.domainName())
    override val enableAutoSubDomain: Option[EnableAutoSubDomain] = scala
      .Option(impl.enableAutoSubDomain())
      .map(value => zio.aws.amplify.model.primitives.EnableAutoSubDomain(value))
    override val subDomainSettings
        : List[zio.aws.amplify.model.SubDomainSetting.ReadOnly] = impl
      .subDomainSettings()
      .asScala
      .map { item =>
        zio.aws.amplify.model.SubDomainSetting.wrap(item)
      }
      .toList
    override val autoSubDomainCreationPatterns
        : Option[List[AutoSubDomainCreationPattern]] = scala
      .Option(impl.autoSubDomainCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoSubDomainCreationPattern(item)
        }.toList
      )
    override val autoSubDomainIAMRole: Option[AutoSubDomainIAMRole] = scala
      .Option(impl.autoSubDomainIAMRole())
      .map(value =>
        zio.aws.amplify.model.primitives.AutoSubDomainIAMRole(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateDomainAssociationRequest
  ): zio.aws.amplify.model.CreateDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
