package zio.aws.amplify.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  NextToken,
  MaxResults,
  JobId,
  AppId,
  BranchName
}
import scala.jdk.CollectionConverters.*
final case class ListArtifactsRequest(
    appId: AppId,
    branchName: BranchName,
    jobId: JobId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListArtifactsRequest = {
    import ListArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListArtifactsRequest.ReadOnly =
    zio.aws.amplify.model.ListArtifactsRequest.wrap(buildAwsValue())
}
object ListArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListArtifactsRequest =
      zio.aws.amplify.model.ListArtifactsRequest(
        appId,
        branchName,
        jobId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def jobId: JobId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ) extends zio.aws.amplify.model.ListArtifactsRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val jobId: JobId =
      zio.aws.amplify.model.primitives.JobId(impl.jobId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.amplify.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListArtifactsRequest
  ): zio.aws.amplify.model.ListArtifactsRequest.ReadOnly = new Wrapper(impl)
}
