package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.amplify.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListTagsForResourceRequest =
      zio.aws.amplify.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest
  ) extends zio.aws.amplify.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.amplify.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListTagsForResourceRequest
  ): zio.aws.amplify.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
