package zio.aws.amplify.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{MaxResults, NextToken, AppId}
import scala.jdk.CollectionConverters.*
final case class ListWebhooksRequest(
    appId: AppId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListWebhooksRequest = {
    import ListWebhooksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListWebhooksRequest.ReadOnly =
    zio.aws.amplify.model.ListWebhooksRequest.wrap(buildAwsValue())
}
object ListWebhooksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListWebhooksRequest =
      zio.aws.amplify.model.ListWebhooksRequest(
        appId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appId: AppId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ) extends zio.aws.amplify.model.ListWebhooksRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.amplify.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksRequest
  ): zio.aws.amplify.model.ListWebhooksRequest.ReadOnly = new Wrapper(impl)
}
