package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListWebhooksResponse(
    webhooks: Iterable[zio.aws.amplify.model.Webhook],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListWebhooksResponse = {
    import ListWebhooksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListWebhooksResponse
      .builder()
      .webhooks(webhooks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListWebhooksResponse.ReadOnly =
    zio.aws.amplify.model.ListWebhooksResponse.wrap(buildAwsValue())
}
object ListWebhooksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListWebhooksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListWebhooksResponse =
      zio.aws.amplify.model.ListWebhooksResponse(
        webhooks.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def webhooks: List[zio.aws.amplify.model.Webhook.ReadOnly]
    def nextToken: Option[NextToken]
    def getWebhooks
        : ZIO[Any, Nothing, List[zio.aws.amplify.model.Webhook.ReadOnly]] =
      ZIO.succeed(webhooks)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksResponse
  ) extends zio.aws.amplify.model.ListWebhooksResponse.ReadOnly {
    override val webhooks: List[zio.aws.amplify.model.Webhook.ReadOnly] = impl
      .webhooks()
      .asScala
      .map { item =>
        zio.aws.amplify.model.Webhook.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListWebhooksResponse
  ): zio.aws.amplify.model.ListWebhooksResponse.ReadOnly = new Wrapper(impl)
}
