package zio.aws.amplify.model
import scala.jdk.CollectionConverters.*
sealed trait Platform {
  def unwrap: software.amazon.awssdk.services.amplify.model.Platform
}
object Platform {
  def wrap(
      value: software.amazon.awssdk.services.amplify.model.Platform
  ): zio.aws.amplify.model.Platform = value match {
    case software.amazon.awssdk.services.amplify.model.Platform.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplify.model.Platform.WEB =>
      val r = WEB
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplify.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.Platform =
      software.amazon.awssdk.services.amplify.model.Platform.UNKNOWN_TO_SDK_VERSION
  }
  case object WEB extends zio.aws.amplify.model.Platform {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.Platform =
      software.amazon.awssdk.services.amplify.model.Platform.WEB
  }
}
