package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartJobResponse(
    jobSummary: zio.aws.amplify.model.JobSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.StartJobResponse = {
    import StartJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.StartJobResponse
      .builder()
      .jobSummary(jobSummary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.StartJobResponse.ReadOnly =
    zio.aws.amplify.model.StartJobResponse.wrap(buildAwsValue())
}
object StartJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.StartJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.StartJobResponse =
      zio.aws.amplify.model.StartJobResponse(jobSummary.asEditable)
    def jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly
    def getJobSummary
        : ZIO[Any, Nothing, zio.aws.amplify.model.JobSummary.ReadOnly] =
      ZIO.succeed(jobSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.StartJobResponse
  ) extends zio.aws.amplify.model.StartJobResponse.ReadOnly {
    override val jobSummary: zio.aws.amplify.model.JobSummary.ReadOnly =
      zio.aws.amplify.model.JobSummary.wrap(impl.jobSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.StartJobResponse
  ): zio.aws.amplify.model.StartJobResponse.ReadOnly = new Wrapper(impl)
}
