package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableAutoBuild,
  CustomHeaders,
  BuildSpec,
  EnableAutoBranchCreation,
  Repository,
  BasicAuthCredentials,
  ServiceRoleArn,
  Description,
  AutoBranchCreationPattern,
  AppId,
  EnvValue,
  EnvKey,
  EnableBranchAutoDeletion,
  OauthToken,
  Name,
  AccessToken
}
import scala.jdk.CollectionConverters.*
final case class UpdateAppRequest(
    appId: AppId,
    name: Option[Name] = None,
    description: Option[Description] = None,
    platform: Option[zio.aws.amplify.model.Platform] = None,
    iamServiceRoleArn: Option[ServiceRoleArn] = None,
    environmentVariables: Option[Map[EnvKey, EnvValue]] = None,
    enableBranchAutoBuild: Option[EnableAutoBuild] = None,
    enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] = None,
    enableBasicAuth: Option[EnableBasicAuth] = None,
    basicAuthCredentials: Option[BasicAuthCredentials] = None,
    customRules: Option[Iterable[zio.aws.amplify.model.CustomRule]] = None,
    buildSpec: Option[BuildSpec] = None,
    customHeaders: Option[CustomHeaders] = None,
    enableAutoBranchCreation: Option[EnableAutoBranchCreation] = None,
    autoBranchCreationPatterns: Option[Iterable[AutoBranchCreationPattern]] =
      None,
    autoBranchCreationConfig: Option[
      zio.aws.amplify.model.AutoBranchCreationConfig
    ] = None,
    repository: Option[Repository] = None,
    oauthToken: Option[OauthToken] = None,
    accessToken: Option[AccessToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateAppRequest = {
    import UpdateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateAppRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        iamServiceRoleArn.map(value =>
          ServiceRoleArn.unwrap(value): java.lang.String
        )
      )(_.iamServiceRoleArn)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        enableBranchAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoBuild)
      .optionallyWith(
        enableBranchAutoDeletion.map(value =>
          EnableBranchAutoDeletion.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoDeletion)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        customRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customRules)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        customHeaders.map(value =>
          CustomHeaders.unwrap(value): java.lang.String
        )
      )(_.customHeaders)
      .optionallyWith(
        enableAutoBranchCreation.map(value =>
          EnableAutoBranchCreation.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBranchCreation)
      .optionallyWith(
        autoBranchCreationPatterns.map(value =>
          value.map { item =>
            AutoBranchCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoBranchCreationPatterns)
      .optionallyWith(
        autoBranchCreationConfig.map(value => value.buildAwsValue())
      )(_.autoBranchCreationConfig)
      .optionallyWith(
        repository.map(value => Repository.unwrap(value): java.lang.String)
      )(_.repository)
      .optionallyWith(
        oauthToken.map(value => OauthToken.unwrap(value): java.lang.String)
      )(_.oauthToken)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateAppRequest.ReadOnly =
    zio.aws.amplify.model.UpdateAppRequest.wrap(buildAwsValue())
}
object UpdateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateAppRequest =
      zio.aws.amplify.model.UpdateAppRequest(
        appId,
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        iamServiceRoleArn.map(value => value),
        environmentVariables.map(value => value),
        enableBranchAutoBuild.map(value => value),
        enableBranchAutoDeletion.map(value => value),
        enableBasicAuth.map(value => value),
        basicAuthCredentials.map(value => value),
        customRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildSpec.map(value => value),
        customHeaders.map(value => value),
        enableAutoBranchCreation.map(value => value),
        autoBranchCreationPatterns.map(value => value),
        autoBranchCreationConfig.map(value => value.asEditable),
        repository.map(value => value),
        oauthToken.map(value => value),
        accessToken.map(value => value)
      )
    def appId: AppId
    def name: Option[Name]
    def description: Option[Description]
    def platform: Option[zio.aws.amplify.model.Platform]
    def iamServiceRoleArn: Option[ServiceRoleArn]
    def environmentVariables: Option[Map[EnvKey, EnvValue]]
    def enableBranchAutoBuild: Option[EnableAutoBuild]
    def enableBranchAutoDeletion: Option[EnableBranchAutoDeletion]
    def enableBasicAuth: Option[EnableBasicAuth]
    def basicAuthCredentials: Option[BasicAuthCredentials]
    def customRules: Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]]
    def buildSpec: Option[BuildSpec]
    def customHeaders: Option[CustomHeaders]
    def enableAutoBranchCreation: Option[EnableAutoBranchCreation]
    def autoBranchCreationPatterns: Option[List[AutoBranchCreationPattern]]
    def autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly]
    def repository: Option[Repository]
    def oauthToken: Option[OauthToken]
    def accessToken: Option[AccessToken]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.amplify.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getIamServiceRoleArn: ZIO[Any, AwsError, ServiceRoleArn] =
      AwsError.unwrapOptionField("iamServiceRoleArn", iamServiceRoleArn)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getEnableBranchAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableBranchAutoBuild", enableBranchAutoBuild)
    def getEnableBranchAutoDeletion
        : ZIO[Any, AwsError, EnableBranchAutoDeletion] = AwsError
      .unwrapOptionField("enableBranchAutoDeletion", enableBranchAutoDeletion)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getCustomRules
        : ZIO[Any, AwsError, List[zio.aws.amplify.model.CustomRule.ReadOnly]] =
      AwsError.unwrapOptionField("customRules", customRules)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getCustomHeaders: ZIO[Any, AwsError, CustomHeaders] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getEnableAutoBranchCreation
        : ZIO[Any, AwsError, EnableAutoBranchCreation] = AwsError
      .unwrapOptionField("enableAutoBranchCreation", enableAutoBranchCreation)
    def getAutoBranchCreationPatterns
        : ZIO[Any, AwsError, List[AutoBranchCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoBranchCreationPatterns",
        autoBranchCreationPatterns
      )
    def getAutoBranchCreationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoBranchCreationConfig",
      autoBranchCreationConfig
    )
    def getRepository: ZIO[Any, AwsError, Repository] =
      AwsError.unwrapOptionField("repository", repository)
    def getOauthToken: ZIO[Any, AwsError, OauthToken] =
      AwsError.unwrapOptionField("oauthToken", oauthToken)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ) extends zio.aws.amplify.model.UpdateAppRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.amplify.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
    override val platform: Option[zio.aws.amplify.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.amplify.model.Platform.wrap(value))
    override val iamServiceRoleArn: Option[ServiceRoleArn] = scala
      .Option(impl.iamServiceRoleArn())
      .map(value => zio.aws.amplify.model.primitives.ServiceRoleArn(value))
    override val environmentVariables: Option[Map[EnvKey, EnvValue]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
          })
          .toMap
      )
    override val enableBranchAutoBuild: Option[EnableAutoBuild] = scala
      .Option(impl.enableBranchAutoBuild())
      .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val enableBranchAutoDeletion: Option[EnableBranchAutoDeletion] =
      scala
        .Option(impl.enableBranchAutoDeletion())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableBranchAutoDeletion(value)
        )
    override val enableBasicAuth: Option[EnableBasicAuth] = scala
      .Option(impl.enableBasicAuth())
      .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val basicAuthCredentials: Option[BasicAuthCredentials] = scala
      .Option(impl.basicAuthCredentials())
      .map(value =>
        zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
      )
    override val customRules
        : Option[List[zio.aws.amplify.model.CustomRule.ReadOnly]] = scala
      .Option(impl.customRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.CustomRule.wrap(item)
        }.toList
      )
    override val buildSpec: Option[BuildSpec] = scala
      .Option(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val customHeaders: Option[CustomHeaders] = scala
      .Option(impl.customHeaders())
      .map(value => zio.aws.amplify.model.primitives.CustomHeaders(value))
    override val enableAutoBranchCreation: Option[EnableAutoBranchCreation] =
      scala
        .Option(impl.enableAutoBranchCreation())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableAutoBranchCreation(value)
        )
    override val autoBranchCreationPatterns
        : Option[List[AutoBranchCreationPattern]] = scala
      .Option(impl.autoBranchCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoBranchCreationPattern(item)
        }.toList
      )
    override val autoBranchCreationConfig
        : Option[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly] =
      scala
        .Option(impl.autoBranchCreationConfig())
        .map(value =>
          zio.aws.amplify.model.AutoBranchCreationConfig.wrap(value)
        )
    override val repository: Option[Repository] = scala
      .Option(impl.repository())
      .map(value => zio.aws.amplify.model.primitives.Repository(value))
    override val oauthToken: Option[OauthToken] = scala
      .Option(impl.oauthToken())
      .map(value => zio.aws.amplify.model.primitives.OauthToken(value))
    override val accessToken: Option[AccessToken] = scala
      .Option(impl.accessToken())
      .map(value => zio.aws.amplify.model.primitives.AccessToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ): zio.aws.amplify.model.UpdateAppRequest.ReadOnly = new Wrapper(impl)
}
