package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBranchResponse(branch: zio.aws.amplify.model.Branch) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateBranchResponse = {
    import UpdateBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateBranchResponse
      .builder()
      .branch(branch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateBranchResponse.ReadOnly =
    zio.aws.amplify.model.UpdateBranchResponse.wrap(buildAwsValue())
}
object UpdateBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateBranchResponse =
      zio.aws.amplify.model.UpdateBranchResponse(branch.asEditable)
    def branch: zio.aws.amplify.model.Branch.ReadOnly
    def getBranch: ZIO[Any, Nothing, zio.aws.amplify.model.Branch.ReadOnly] =
      ZIO.succeed(branch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateBranchResponse
  ) extends zio.aws.amplify.model.UpdateBranchResponse.ReadOnly {
    override val branch: zio.aws.amplify.model.Branch.ReadOnly =
      zio.aws.amplify.model.Branch.wrap(impl.branch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateBranchResponse
  ): zio.aws.amplify.model.UpdateBranchResponse.ReadOnly = new Wrapper(impl)
}
