package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{Description, BranchName, WebhookId}
import scala.jdk.CollectionConverters.*
final case class UpdateWebhookRequest(
    webhookId: WebhookId,
    branchName: Option[BranchName] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest = {
    import UpdateWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest
      .builder()
      .webhookId(WebhookId.unwrap(webhookId): java.lang.String)
      .optionallyWith(
        branchName.map(value => BranchName.unwrap(value): java.lang.String)
      )(_.branchName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateWebhookRequest.ReadOnly =
    zio.aws.amplify.model.UpdateWebhookRequest.wrap(buildAwsValue())
}
object UpdateWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateWebhookRequest =
      zio.aws.amplify.model.UpdateWebhookRequest(
        webhookId,
        branchName.map(value => value),
        description.map(value => value)
      )
    def webhookId: WebhookId
    def branchName: Option[BranchName]
    def description: Option[Description]
    def getWebhookId: ZIO[Any, Nothing, WebhookId] = ZIO.succeed(webhookId)
    def getBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("branchName", branchName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest
  ) extends zio.aws.amplify.model.UpdateWebhookRequest.ReadOnly {
    override val webhookId: WebhookId =
      zio.aws.amplify.model.primitives.WebhookId(impl.webhookId())
    override val branchName: Option[BranchName] = scala
      .Option(impl.branchName())
      .map(value => zio.aws.amplify.model.primitives.BranchName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateWebhookRequest
  ): zio.aws.amplify.model.UpdateWebhookRequest.ReadOnly = new Wrapper(impl)
}
