package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableAutoBuild,
  PullRequestEnvironmentName,
  BuildSpec,
  EnablePullRequestPreview,
  BasicAuthCredentials,
  EnablePerformanceMode,
  EnvValue,
  EnvKey,
  Framework
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoBranchCreationConfig(
    stage: Optional[zio.aws.amplify.model.Stage] = Optional.Absent,
    framework: Optional[Framework] = Optional.Absent,
    enableAutoBuild: Optional[EnableAutoBuild] = Optional.Absent,
    environmentVariables: Optional[Map[EnvKey, EnvValue]] = Optional.Absent,
    basicAuthCredentials: Optional[BasicAuthCredentials] = Optional.Absent,
    enableBasicAuth: Optional[EnableBasicAuth] = Optional.Absent,
    enablePerformanceMode: Optional[EnablePerformanceMode] = Optional.Absent,
    buildSpec: Optional[BuildSpec] = Optional.Absent,
    enablePullRequestPreview: Optional[EnablePullRequestPreview] =
      Optional.Absent,
    pullRequestEnvironmentName: Optional[PullRequestEnvironmentName] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig = {
    import AutoBranchCreationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
      .builder()
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .optionallyWith(
        framework.map(value => Framework.unwrap(value): java.lang.String)
      )(_.framework)
      .optionallyWith(
        enableAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBuild)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        enablePerformanceMode.map(value =>
          EnablePerformanceMode.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceMode)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        enablePullRequestPreview.map(value =>
          EnablePullRequestPreview.unwrap(value): java.lang.Boolean
        )
      )(_.enablePullRequestPreview)
      .optionallyWith(
        pullRequestEnvironmentName.map(value =>
          PullRequestEnvironmentName.unwrap(value): java.lang.String
        )
      )(_.pullRequestEnvironmentName)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly =
    zio.aws.amplify.model.AutoBranchCreationConfig.wrap(buildAwsValue())
}
object AutoBranchCreationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.AutoBranchCreationConfig =
      zio.aws.amplify.model.AutoBranchCreationConfig(
        stage.map(value => value),
        framework.map(value => value),
        enableAutoBuild.map(value => value),
        environmentVariables.map(value => value),
        basicAuthCredentials.map(value => value),
        enableBasicAuth.map(value => value),
        enablePerformanceMode.map(value => value),
        buildSpec.map(value => value),
        enablePullRequestPreview.map(value => value),
        pullRequestEnvironmentName.map(value => value)
      )
    def stage: Optional[zio.aws.amplify.model.Stage]
    def framework: Optional[Framework]
    def enableAutoBuild: Optional[EnableAutoBuild]
    def environmentVariables: Optional[Map[EnvKey, EnvValue]]
    def basicAuthCredentials: Optional[BasicAuthCredentials]
    def enableBasicAuth: Optional[EnableBasicAuth]
    def enablePerformanceMode: Optional[EnablePerformanceMode]
    def buildSpec: Optional[BuildSpec]
    def enablePullRequestPreview: Optional[EnablePullRequestPreview]
    def pullRequestEnvironmentName: Optional[PullRequestEnvironmentName]
    def getStage: ZIO[Any, AwsError, zio.aws.amplify.model.Stage] =
      AwsError.unwrapOptionField("stage", stage)
    def getFramework: ZIO[Any, AwsError, Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getEnableAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableAutoBuild", enableAutoBuild)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getEnablePerformanceMode: ZIO[Any, AwsError, EnablePerformanceMode] =
      AwsError.unwrapOptionField("enablePerformanceMode", enablePerformanceMode)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getEnablePullRequestPreview
        : ZIO[Any, AwsError, EnablePullRequestPreview] = AwsError
      .unwrapOptionField("enablePullRequestPreview", enablePullRequestPreview)
    def getPullRequestEnvironmentName
        : ZIO[Any, AwsError, PullRequestEnvironmentName] =
      AwsError.unwrapOptionField(
        "pullRequestEnvironmentName",
        pullRequestEnvironmentName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ) extends zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly {
    override val stage: Optional[zio.aws.amplify.model.Stage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.amplify.model.Stage.wrap(value))
    override val framework: Optional[Framework] = zio.aws.core.internal
      .optionalFromNullable(impl.framework())
      .map(value => zio.aws.amplify.model.primitives.Framework(value))
    override val enableAutoBuild: Optional[EnableAutoBuild] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAutoBuild())
        .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val environmentVariables: Optional[Map[EnvKey, EnvValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.amplify.model.primitives
                .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
            })
            .toMap
        )
    override val basicAuthCredentials: Optional[BasicAuthCredentials] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basicAuthCredentials())
        .map(value =>
          zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
        )
    override val enableBasicAuth: Optional[EnableBasicAuth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBasicAuth())
        .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val enablePerformanceMode: Optional[EnablePerformanceMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceMode())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePerformanceMode(value)
        )
    override val buildSpec: Optional[BuildSpec] = zio.aws.core.internal
      .optionalFromNullable(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val enablePullRequestPreview: Optional[EnablePullRequestPreview] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePullRequestPreview())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePullRequestPreview(value)
        )
    override val pullRequestEnvironmentName
        : Optional[PullRequestEnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestEnvironmentName())
      .map(value =>
        zio.aws.amplify.model.primitives.PullRequestEnvironmentName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.AutoBranchCreationConfig
  ): zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly = new Wrapper(impl)
}
