package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableNotification,
  EnableAutoBuild,
  DisplayName,
  PullRequestEnvironmentName,
  TTL,
  BuildSpec,
  EnablePullRequestPreview,
  BasicAuthCredentials,
  TagValue,
  Description,
  EnablePerformanceMode,
  AppId,
  EnvValue,
  EnvKey,
  BackendEnvironmentArn,
  Framework,
  BranchName,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBranchRequest(
    appId: AppId,
    branchName: BranchName,
    description: Optional[Description] = Optional.Absent,
    stage: Optional[zio.aws.amplify.model.Stage] = Optional.Absent,
    framework: Optional[Framework] = Optional.Absent,
    enableNotification: Optional[EnableNotification] = Optional.Absent,
    enableAutoBuild: Optional[EnableAutoBuild] = Optional.Absent,
    environmentVariables: Optional[Map[EnvKey, EnvValue]] = Optional.Absent,
    basicAuthCredentials: Optional[BasicAuthCredentials] = Optional.Absent,
    enableBasicAuth: Optional[EnableBasicAuth] = Optional.Absent,
    enablePerformanceMode: Optional[EnablePerformanceMode] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    buildSpec: Optional[BuildSpec] = Optional.Absent,
    ttl: Optional[TTL] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    enablePullRequestPreview: Optional[EnablePullRequestPreview] =
      Optional.Absent,
    pullRequestEnvironmentName: Optional[PullRequestEnvironmentName] =
      Optional.Absent,
    backendEnvironmentArn: Optional[BackendEnvironmentArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateBranchRequest = {
    import CreateBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateBranchRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(stage.map(value => value.unwrap))(_.stage)
      .optionallyWith(
        framework.map(value => Framework.unwrap(value): java.lang.String)
      )(_.framework)
      .optionallyWith(
        enableNotification.map(value =>
          EnableNotification.unwrap(value): java.lang.Boolean
        )
      )(_.enableNotification)
      .optionallyWith(
        enableAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBuild)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        enablePerformanceMode.map(value =>
          EnablePerformanceMode.unwrap(value): java.lang.Boolean
        )
      )(_.enablePerformanceMode)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(ttl.map(value => TTL.unwrap(value): java.lang.String))(
        _.ttl
      )
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        enablePullRequestPreview.map(value =>
          EnablePullRequestPreview.unwrap(value): java.lang.Boolean
        )
      )(_.enablePullRequestPreview)
      .optionallyWith(
        pullRequestEnvironmentName.map(value =>
          PullRequestEnvironmentName.unwrap(value): java.lang.String
        )
      )(_.pullRequestEnvironmentName)
      .optionallyWith(
        backendEnvironmentArn.map(value =>
          BackendEnvironmentArn.unwrap(value): java.lang.String
        )
      )(_.backendEnvironmentArn)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateBranchRequest.ReadOnly =
    zio.aws.amplify.model.CreateBranchRequest.wrap(buildAwsValue())
}
object CreateBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateBranchRequest =
      zio.aws.amplify.model.CreateBranchRequest(
        appId,
        branchName,
        description.map(value => value),
        stage.map(value => value),
        framework.map(value => value),
        enableNotification.map(value => value),
        enableAutoBuild.map(value => value),
        environmentVariables.map(value => value),
        basicAuthCredentials.map(value => value),
        enableBasicAuth.map(value => value),
        enablePerformanceMode.map(value => value),
        tags.map(value => value),
        buildSpec.map(value => value),
        ttl.map(value => value),
        displayName.map(value => value),
        enablePullRequestPreview.map(value => value),
        pullRequestEnvironmentName.map(value => value),
        backendEnvironmentArn.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def description: Optional[Description]
    def stage: Optional[zio.aws.amplify.model.Stage]
    def framework: Optional[Framework]
    def enableNotification: Optional[EnableNotification]
    def enableAutoBuild: Optional[EnableAutoBuild]
    def environmentVariables: Optional[Map[EnvKey, EnvValue]]
    def basicAuthCredentials: Optional[BasicAuthCredentials]
    def enableBasicAuth: Optional[EnableBasicAuth]
    def enablePerformanceMode: Optional[EnablePerformanceMode]
    def tags: Optional[Map[TagKey, TagValue]]
    def buildSpec: Optional[BuildSpec]
    def ttl: Optional[TTL]
    def displayName: Optional[DisplayName]
    def enablePullRequestPreview: Optional[EnablePullRequestPreview]
    def pullRequestEnvironmentName: Optional[PullRequestEnvironmentName]
    def backendEnvironmentArn: Optional[BackendEnvironmentArn]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStage: ZIO[Any, AwsError, zio.aws.amplify.model.Stage] =
      AwsError.unwrapOptionField("stage", stage)
    def getFramework: ZIO[Any, AwsError, Framework] =
      AwsError.unwrapOptionField("framework", framework)
    def getEnableNotification: ZIO[Any, AwsError, EnableNotification] =
      AwsError.unwrapOptionField("enableNotification", enableNotification)
    def getEnableAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableAutoBuild", enableAutoBuild)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getEnablePerformanceMode: ZIO[Any, AwsError, EnablePerformanceMode] =
      AwsError.unwrapOptionField("enablePerformanceMode", enablePerformanceMode)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getTtl: ZIO[Any, AwsError, TTL] = AwsError.unwrapOptionField("ttl", ttl)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEnablePullRequestPreview
        : ZIO[Any, AwsError, EnablePullRequestPreview] = AwsError
      .unwrapOptionField("enablePullRequestPreview", enablePullRequestPreview)
    def getPullRequestEnvironmentName
        : ZIO[Any, AwsError, PullRequestEnvironmentName] =
      AwsError.unwrapOptionField(
        "pullRequestEnvironmentName",
        pullRequestEnvironmentName
      )
    def getBackendEnvironmentArn: ZIO[Any, AwsError, BackendEnvironmentArn] =
      AwsError.unwrapOptionField("backendEnvironmentArn", backendEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateBranchRequest
  ) extends zio.aws.amplify.model.CreateBranchRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
    override val stage: Optional[zio.aws.amplify.model.Stage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.amplify.model.Stage.wrap(value))
    override val framework: Optional[Framework] = zio.aws.core.internal
      .optionalFromNullable(impl.framework())
      .map(value => zio.aws.amplify.model.primitives.Framework(value))
    override val enableNotification: Optional[EnableNotification] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNotification())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableNotification(value)
        )
    override val enableAutoBuild: Optional[EnableAutoBuild] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAutoBuild())
        .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val environmentVariables: Optional[Map[EnvKey, EnvValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.amplify.model.primitives
                .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
            })
            .toMap
        )
    override val basicAuthCredentials: Optional[BasicAuthCredentials] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basicAuthCredentials())
        .map(value =>
          zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
        )
    override val enableBasicAuth: Optional[EnableBasicAuth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBasicAuth())
        .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val enablePerformanceMode: Optional[EnablePerformanceMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceMode())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePerformanceMode(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.amplify.model.primitives
              .TagKey(key) -> zio.aws.amplify.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildSpec: Optional[BuildSpec] = zio.aws.core.internal
      .optionalFromNullable(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val ttl: Optional[TTL] = zio.aws.core.internal
      .optionalFromNullable(impl.ttl())
      .map(value => zio.aws.amplify.model.primitives.TTL(value))
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.amplify.model.primitives.DisplayName(value))
    override val enablePullRequestPreview: Optional[EnablePullRequestPreview] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePullRequestPreview())
        .map(value =>
          zio.aws.amplify.model.primitives.EnablePullRequestPreview(value)
        )
    override val pullRequestEnvironmentName
        : Optional[PullRequestEnvironmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.pullRequestEnvironmentName())
      .map(value =>
        zio.aws.amplify.model.primitives.PullRequestEnvironmentName(value)
      )
    override val backendEnvironmentArn: Optional[BackendEnvironmentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backendEnvironmentArn())
        .map(value =>
          zio.aws.amplify.model.primitives.BackendEnvironmentArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateBranchRequest
  ): zio.aws.amplify.model.CreateBranchRequest.ReadOnly = new Wrapper(impl)
}
