package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{UploadUrl, FileName, JobId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentResponse(
    jobId: Optional[JobId] = Optional.Absent,
    fileUploadUrls: Map[FileName, UploadUrl],
    zipUploadUrl: UploadUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse = {
    import CreateDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .fileUploadUrls(
        fileUploadUrls
          .map({ case (key, value) =>
            (FileName.unwrap(key): java.lang.String) -> (UploadUrl
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .zipUploadUrl(UploadUrl.unwrap(zipUploadUrl): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly =
    zio.aws.amplify.model.CreateDeploymentResponse.wrap(buildAwsValue())
}
object CreateDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateDeploymentResponse =
      zio.aws.amplify.model.CreateDeploymentResponse(
        jobId.map(value => value),
        fileUploadUrls,
        zipUploadUrl
      )
    def jobId: Optional[JobId]
    def fileUploadUrls: Map[FileName, UploadUrl]
    def zipUploadUrl: UploadUrl
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getFileUploadUrls: ZIO[Any, Nothing, Map[FileName, UploadUrl]] =
      ZIO.succeed(fileUploadUrls)
    def getZipUploadUrl: ZIO[Any, Nothing, UploadUrl] =
      ZIO.succeed(zipUploadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse
  ) extends zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.amplify.model.primitives.JobId(value))
    override val fileUploadUrls: Map[FileName, UploadUrl] = impl
      .fileUploadUrls()
      .asScala
      .map({ case (key, value) =>
        zio.aws.amplify.model.primitives
          .FileName(key) -> zio.aws.amplify.model.primitives.UploadUrl(value)
      })
      .toMap
    override val zipUploadUrl: UploadUrl =
      zio.aws.amplify.model.primitives.UploadUrl(impl.zipUploadUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateDeploymentResponse
  ): zio.aws.amplify.model.CreateDeploymentResponse.ReadOnly = new Wrapper(impl)
}
