package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{Condition, Status, Target, Source}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomRule(
    source: Source,
    target: Target,
    status: Optional[Status] = Optional.Absent,
    condition: Optional[Condition] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CustomRule = {
    import CustomRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CustomRule
      .builder()
      .source(Source.unwrap(source): java.lang.String)
      .target(Target.unwrap(target): java.lang.String)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        condition.map(value => Condition.unwrap(value): java.lang.String)
      )(_.condition)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CustomRule.ReadOnly =
    zio.aws.amplify.model.CustomRule.wrap(buildAwsValue())
}
object CustomRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CustomRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CustomRule =
      zio.aws.amplify.model.CustomRule(
        source,
        target,
        status.map(value => value),
        condition.map(value => value)
      )
    def source: Source
    def target: Target
    def status: Optional[Status]
    def condition: Optional[Condition]
    def getSource: ZIO[Any, Nothing, Source] = ZIO.succeed(source)
    def getTarget: ZIO[Any, Nothing, Target] = ZIO.succeed(target)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCondition: ZIO[Any, AwsError, Condition] =
      AwsError.unwrapOptionField("condition", condition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CustomRule
  ) extends zio.aws.amplify.model.CustomRule.ReadOnly {
    override val source: Source =
      zio.aws.amplify.model.primitives.Source(impl.source())
    override val target: Target =
      zio.aws.amplify.model.primitives.Target(impl.target())
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.amplify.model.primitives.Status(value))
    override val condition: Optional[Condition] = zio.aws.core.internal
      .optionalFromNullable(impl.condition())
      .map(value => zio.aws.amplify.model.primitives.Condition(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CustomRule
  ): zio.aws.amplify.model.CustomRule.ReadOnly = new Wrapper(impl)
}
