package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBranchResponse(branch: zio.aws.amplify.model.Branch) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteBranchResponse = {
    import DeleteBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteBranchResponse
      .builder()
      .branch(branch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteBranchResponse.ReadOnly =
    zio.aws.amplify.model.DeleteBranchResponse.wrap(buildAwsValue())
}
object DeleteBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteBranchResponse =
      zio.aws.amplify.model.DeleteBranchResponse(branch.asEditable)
    def branch: zio.aws.amplify.model.Branch.ReadOnly
    def getBranch: ZIO[Any, Nothing, zio.aws.amplify.model.Branch.ReadOnly] =
      ZIO.succeed(branch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBranchResponse
  ) extends zio.aws.amplify.model.DeleteBranchResponse.ReadOnly {
    override val branch: zio.aws.amplify.model.Branch.ReadOnly =
      zio.aws.amplify.model.Branch.wrap(impl.branch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBranchResponse
  ): zio.aws.amplify.model.DeleteBranchResponse.ReadOnly = new Wrapper(impl)
}
