package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.WebhookId
import scala.jdk.CollectionConverters.*
final case class DeleteWebhookRequest(webhookId: WebhookId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest = {
    import DeleteWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest
      .builder()
      .webhookId(WebhookId.unwrap(webhookId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteWebhookRequest.ReadOnly =
    zio.aws.amplify.model.DeleteWebhookRequest.wrap(buildAwsValue())
}
object DeleteWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteWebhookRequest =
      zio.aws.amplify.model.DeleteWebhookRequest(webhookId)
    def webhookId: WebhookId
    def getWebhookId: ZIO[Any, Nothing, WebhookId] = ZIO.succeed(webhookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest
  ) extends zio.aws.amplify.model.DeleteWebhookRequest.ReadOnly {
    override val webhookId: WebhookId =
      zio.aws.amplify.model.primitives.WebhookId(impl.webhookId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteWebhookRequest
  ): zio.aws.amplify.model.DeleteWebhookRequest.ReadOnly = new Wrapper(impl)
}
