package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  StatusReason,
  DomainName,
  CertificateVerificationDNSRecord,
  AutoSubDomainIAMRole,
  EnableAutoSubDomain,
  DomainAssociationArn,
  AutoSubDomainCreationPattern
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainAssociation(
    domainAssociationArn: DomainAssociationArn,
    domainName: DomainName,
    enableAutoSubDomain: EnableAutoSubDomain,
    autoSubDomainCreationPatterns: Optional[
      Iterable[AutoSubDomainCreationPattern]
    ] = Optional.Absent,
    autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole] = Optional.Absent,
    domainStatus: zio.aws.amplify.model.DomainStatus,
    statusReason: StatusReason,
    certificateVerificationDNSRecord: Optional[
      CertificateVerificationDNSRecord
    ] = Optional.Absent,
    subDomains: Iterable[zio.aws.amplify.model.SubDomain]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DomainAssociation = {
    import DomainAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DomainAssociation
      .builder()
      .domainAssociationArn(
        DomainAssociationArn.unwrap(domainAssociationArn): java.lang.String
      )
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .enableAutoSubDomain(
        EnableAutoSubDomain.unwrap(enableAutoSubDomain): java.lang.Boolean
      )
      .optionallyWith(
        autoSubDomainCreationPatterns.map(value =>
          value.map { item =>
            AutoSubDomainCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoSubDomainCreationPatterns)
      .optionallyWith(
        autoSubDomainIAMRole.map(value =>
          AutoSubDomainIAMRole.unwrap(value): java.lang.String
        )
      )(_.autoSubDomainIAMRole)
      .domainStatus(domainStatus.unwrap)
      .statusReason(StatusReason.unwrap(statusReason): java.lang.String)
      .optionallyWith(
        certificateVerificationDNSRecord.map(value =>
          CertificateVerificationDNSRecord.unwrap(value): java.lang.String
        )
      )(_.certificateVerificationDNSRecord)
      .subDomains(subDomains.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DomainAssociation.ReadOnly =
    zio.aws.amplify.model.DomainAssociation.wrap(buildAwsValue())
}
object DomainAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DomainAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DomainAssociation =
      zio.aws.amplify.model.DomainAssociation(
        domainAssociationArn,
        domainName,
        enableAutoSubDomain,
        autoSubDomainCreationPatterns.map(value => value),
        autoSubDomainIAMRole.map(value => value),
        domainStatus,
        statusReason,
        certificateVerificationDNSRecord.map(value => value),
        subDomains.map { item =>
          item.asEditable
        }
      )
    def domainAssociationArn: DomainAssociationArn
    def domainName: DomainName
    def enableAutoSubDomain: EnableAutoSubDomain
    def autoSubDomainCreationPatterns
        : Optional[List[AutoSubDomainCreationPattern]]
    def autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole]
    def domainStatus: zio.aws.amplify.model.DomainStatus
    def statusReason: StatusReason
    def certificateVerificationDNSRecord
        : Optional[CertificateVerificationDNSRecord]
    def subDomains: List[zio.aws.amplify.model.SubDomain.ReadOnly]
    def getDomainAssociationArn: ZIO[Any, Nothing, DomainAssociationArn] =
      ZIO.succeed(domainAssociationArn)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getEnableAutoSubDomain: ZIO[Any, Nothing, EnableAutoSubDomain] =
      ZIO.succeed(enableAutoSubDomain)
    def getAutoSubDomainCreationPatterns
        : ZIO[Any, AwsError, List[AutoSubDomainCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoSubDomainCreationPatterns",
        autoSubDomainCreationPatterns
      )
    def getAutoSubDomainIAMRole: ZIO[Any, AwsError, AutoSubDomainIAMRole] =
      AwsError.unwrapOptionField("autoSubDomainIAMRole", autoSubDomainIAMRole)
    def getDomainStatus: ZIO[Any, Nothing, zio.aws.amplify.model.DomainStatus] =
      ZIO.succeed(domainStatus)
    def getStatusReason: ZIO[Any, Nothing, StatusReason] =
      ZIO.succeed(statusReason)
    def getCertificateVerificationDNSRecord
        : ZIO[Any, AwsError, CertificateVerificationDNSRecord] =
      AwsError.unwrapOptionField(
        "certificateVerificationDNSRecord",
        certificateVerificationDNSRecord
      )
    def getSubDomains
        : ZIO[Any, Nothing, List[zio.aws.amplify.model.SubDomain.ReadOnly]] =
      ZIO.succeed(subDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DomainAssociation
  ) extends zio.aws.amplify.model.DomainAssociation.ReadOnly {
    override val domainAssociationArn: DomainAssociationArn =
      zio.aws.amplify.model.primitives
        .DomainAssociationArn(impl.domainAssociationArn())
    override val domainName: DomainName =
      zio.aws.amplify.model.primitives.DomainName(impl.domainName())
    override val enableAutoSubDomain: EnableAutoSubDomain =
      zio.aws.amplify.model.primitives
        .EnableAutoSubDomain(impl.enableAutoSubDomain())
    override val autoSubDomainCreationPatterns
        : Optional[List[AutoSubDomainCreationPattern]] = zio.aws.core.internal
      .optionalFromNullable(impl.autoSubDomainCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoSubDomainCreationPattern(item)
        }.toList
      )
    override val autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoSubDomainIAMRole())
        .map(value =>
          zio.aws.amplify.model.primitives.AutoSubDomainIAMRole(value)
        )
    override val domainStatus: zio.aws.amplify.model.DomainStatus =
      zio.aws.amplify.model.DomainStatus.wrap(impl.domainStatus())
    override val statusReason: StatusReason =
      zio.aws.amplify.model.primitives.StatusReason(impl.statusReason())
    override val certificateVerificationDNSRecord
        : Optional[CertificateVerificationDNSRecord] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateVerificationDNSRecord())
      .map(value =>
        zio.aws.amplify.model.primitives.CertificateVerificationDNSRecord(value)
      )
    override val subDomains: List[zio.aws.amplify.model.SubDomain.ReadOnly] =
      impl
        .subDomains()
        .asScala
        .map { item =>
          zio.aws.amplify.model.SubDomain.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DomainAssociation
  ): zio.aws.amplify.model.DomainAssociation.ReadOnly = new Wrapper(impl)
}
