package zio.aws.amplify.model
import scala.jdk.CollectionConverters.*
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.amplify.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.amplify.model.DomainStatus
  ): zio.aws.amplify.model.DomainStatus = value match {
    case software.amazon.awssdk.services.amplify.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.PENDING_VERIFICATION =>
      val r = PENDING_VERIFICATION
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.PENDING_DEPLOYMENT =>
      val r = PENDING_DEPLOYMENT
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.REQUESTING_CERTIFICATE =>
      val r = REQUESTING_CERTIFICATE
      r
    case software.amazon.awssdk.services.amplify.model.DomainStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_VERIFICATION extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.PENDING_VERIFICATION
  }
  case object IN_PROGRESS extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.IN_PROGRESS
  }
  case object AVAILABLE extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.AVAILABLE
  }
  case object PENDING_DEPLOYMENT extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.PENDING_DEPLOYMENT
  }
  case object FAILED extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.FAILED
  }
  case object CREATING extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.CREATING
  }
  case object REQUESTING_CERTIFICATE
      extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.REQUESTING_CERTIFICATE
  }
  case object UPDATING extends zio.aws.amplify.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.amplify.model.DomainStatus =
      software.amazon.awssdk.services.amplify.model.DomainStatus.UPDATING
  }
}
