package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.AppId
import scala.jdk.CollectionConverters.*
final case class GetAppRequest(appId: AppId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetAppRequest = {
    import GetAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetAppRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetAppRequest.ReadOnly =
    zio.aws.amplify.model.GetAppRequest.wrap(buildAwsValue())
}
object GetAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetAppRequest =
      zio.aws.amplify.model.GetAppRequest(appId)
    def appId: AppId
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetAppRequest
  ) extends zio.aws.amplify.model.GetAppRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetAppRequest
  ): zio.aws.amplify.model.GetAppRequest.ReadOnly = new Wrapper(impl)
}
