package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{ArtifactUrl, ArtifactId}
import scala.jdk.CollectionConverters.*
final case class GetArtifactUrlResponse(
    artifactId: ArtifactId,
    artifactUrl: ArtifactUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse = {
    import GetArtifactUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse
      .builder()
      .artifactId(ArtifactId.unwrap(artifactId): java.lang.String)
      .artifactUrl(ArtifactUrl.unwrap(artifactUrl): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly =
    zio.aws.amplify.model.GetArtifactUrlResponse.wrap(buildAwsValue())
}
object GetArtifactUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetArtifactUrlResponse =
      zio.aws.amplify.model.GetArtifactUrlResponse(artifactId, artifactUrl)
    def artifactId: ArtifactId
    def artifactUrl: ArtifactUrl
    def getArtifactId: ZIO[Any, Nothing, ArtifactId] = ZIO.succeed(artifactId)
    def getArtifactUrl: ZIO[Any, Nothing, ArtifactUrl] =
      ZIO.succeed(artifactUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse
  ) extends zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly {
    override val artifactId: ArtifactId =
      zio.aws.amplify.model.primitives.ArtifactId(impl.artifactId())
    override val artifactUrl: ArtifactUrl =
      zio.aws.amplify.model.primitives.ArtifactUrl(impl.artifactUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetArtifactUrlResponse
  ): zio.aws.amplify.model.GetArtifactUrlResponse.ReadOnly = new Wrapper(impl)
}
