package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{DomainName, AppId}
import scala.jdk.CollectionConverters.*
final case class GetDomainAssociationRequest(
    appId: AppId,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest = {
    import GetDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetDomainAssociationRequest.ReadOnly =
    zio.aws.amplify.model.GetDomainAssociationRequest.wrap(buildAwsValue())
}
object GetDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetDomainAssociationRequest =
      zio.aws.amplify.model.GetDomainAssociationRequest(appId, domainName)
    def appId: AppId
    def domainName: DomainName
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest
  ) extends zio.aws.amplify.model.GetDomainAssociationRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val domainName: DomainName =
      zio.aws.amplify.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetDomainAssociationRequest
  ): zio.aws.amplify.model.GetDomainAssociationRequest.ReadOnly = new Wrapper(
    impl
  )
}
