package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAppsResponse(
    apps: Iterable[zio.aws.amplify.model.App],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListAppsResponse = {
    import ListAppsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListAppsResponse
      .builder()
      .apps(apps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListAppsResponse.ReadOnly =
    zio.aws.amplify.model.ListAppsResponse.wrap(buildAwsValue())
}
object ListAppsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListAppsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListAppsResponse =
      zio.aws.amplify.model.ListAppsResponse(
        apps.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def apps: List[zio.aws.amplify.model.App.ReadOnly]
    def nextToken: Optional[NextToken]
    def getApps: ZIO[Any, Nothing, List[zio.aws.amplify.model.App.ReadOnly]] =
      ZIO.succeed(apps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListAppsResponse
  ) extends zio.aws.amplify.model.ListAppsResponse.ReadOnly {
    override val apps: List[zio.aws.amplify.model.App.ReadOnly] = impl
      .apps()
      .asScala
      .map { item =>
        zio.aws.amplify.model.App.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListAppsResponse
  ): zio.aws.amplify.model.ListAppsResponse.ReadOnly = new Wrapper(impl)
}
