package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListBranchesResponse(
    branches: Iterable[zio.aws.amplify.model.Branch],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.ListBranchesResponse = {
    import ListBranchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.ListBranchesResponse
      .builder()
      .branches(branches.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.ListBranchesResponse.ReadOnly =
    zio.aws.amplify.model.ListBranchesResponse.wrap(buildAwsValue())
}
object ListBranchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.ListBranchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.ListBranchesResponse =
      zio.aws.amplify.model.ListBranchesResponse(
        branches.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def branches: List[zio.aws.amplify.model.Branch.ReadOnly]
    def nextToken: Optional[NextToken]
    def getBranches
        : ZIO[Any, Nothing, List[zio.aws.amplify.model.Branch.ReadOnly]] =
      ZIO.succeed(branches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.ListBranchesResponse
  ) extends zio.aws.amplify.model.ListBranchesResponse.ReadOnly {
    override val branches: List[zio.aws.amplify.model.Branch.ReadOnly] = impl
      .branches()
      .asScala
      .map { item =>
        zio.aws.amplify.model.Branch.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.amplify.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.ListBranchesResponse
  ): zio.aws.amplify.model.ListBranchesResponse.ReadOnly = new Wrapper(impl)
}
