package zio.aws.amplify.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{
  StatusReason,
  ThumbnailName,
  TestArtifactsUrl,
  StepName,
  TestConfigUrl,
  ArtifactsUrl,
  Context,
  EndTime,
  ThumbnailUrl,
  StartTime,
  LogUrl
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Step(
    stepName: StepName,
    startTime: StartTime,
    status: zio.aws.amplify.model.JobStatus,
    endTime: EndTime,
    logUrl: Optional[LogUrl] = Optional.Absent,
    artifactsUrl: Optional[ArtifactsUrl] = Optional.Absent,
    testArtifactsUrl: Optional[TestArtifactsUrl] = Optional.Absent,
    testConfigUrl: Optional[TestConfigUrl] = Optional.Absent,
    screenshots: Optional[Map[ThumbnailName, ThumbnailUrl]] = Optional.Absent,
    statusReason: Optional[StatusReason] = Optional.Absent,
    context: Optional[Context] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.amplify.model.Step = {
    import Step.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.Step
      .builder()
      .stepName(StepName.unwrap(stepName): java.lang.String)
      .startTime(StartTime.unwrap(startTime): Instant)
      .status(status.unwrap)
      .endTime(EndTime.unwrap(endTime): Instant)
      .optionallyWith(
        logUrl.map(value => LogUrl.unwrap(value): java.lang.String)
      )(_.logUrl)
      .optionallyWith(
        artifactsUrl.map(value => ArtifactsUrl.unwrap(value): java.lang.String)
      )(_.artifactsUrl)
      .optionallyWith(
        testArtifactsUrl.map(value =>
          TestArtifactsUrl.unwrap(value): java.lang.String
        )
      )(_.testArtifactsUrl)
      .optionallyWith(
        testConfigUrl.map(value =>
          TestConfigUrl.unwrap(value): java.lang.String
        )
      )(_.testConfigUrl)
      .optionallyWith(
        screenshots.map(value =>
          value
            .map({ case (key, value) =>
              (ThumbnailName.unwrap(key): java.lang.String) -> (ThumbnailUrl
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.screenshots)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        context.map(value => Context.unwrap(value): java.lang.String)
      )(_.context)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.Step.ReadOnly =
    zio.aws.amplify.model.Step.wrap(buildAwsValue())
}
object Step {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.Step] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.Step = zio.aws.amplify.model.Step(
      stepName,
      startTime,
      status,
      endTime,
      logUrl.map(value => value),
      artifactsUrl.map(value => value),
      testArtifactsUrl.map(value => value),
      testConfigUrl.map(value => value),
      screenshots.map(value => value),
      statusReason.map(value => value),
      context.map(value => value)
    )
    def stepName: StepName
    def startTime: StartTime
    def status: zio.aws.amplify.model.JobStatus
    def endTime: EndTime
    def logUrl: Optional[LogUrl]
    def artifactsUrl: Optional[ArtifactsUrl]
    def testArtifactsUrl: Optional[TestArtifactsUrl]
    def testConfigUrl: Optional[TestConfigUrl]
    def screenshots: Optional[Map[ThumbnailName, ThumbnailUrl]]
    def statusReason: Optional[StatusReason]
    def context: Optional[Context]
    def getStepName: ZIO[Any, Nothing, StepName] = ZIO.succeed(stepName)
    def getStartTime: ZIO[Any, Nothing, StartTime] = ZIO.succeed(startTime)
    def getStatus: ZIO[Any, Nothing, zio.aws.amplify.model.JobStatus] =
      ZIO.succeed(status)
    def getEndTime: ZIO[Any, Nothing, EndTime] = ZIO.succeed(endTime)
    def getLogUrl: ZIO[Any, AwsError, LogUrl] =
      AwsError.unwrapOptionField("logUrl", logUrl)
    def getArtifactsUrl: ZIO[Any, AwsError, ArtifactsUrl] =
      AwsError.unwrapOptionField("artifactsUrl", artifactsUrl)
    def getTestArtifactsUrl: ZIO[Any, AwsError, TestArtifactsUrl] =
      AwsError.unwrapOptionField("testArtifactsUrl", testArtifactsUrl)
    def getTestConfigUrl: ZIO[Any, AwsError, TestConfigUrl] =
      AwsError.unwrapOptionField("testConfigUrl", testConfigUrl)
    def getScreenshots: ZIO[Any, AwsError, Map[ThumbnailName, ThumbnailUrl]] =
      AwsError.unwrapOptionField("screenshots", screenshots)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getContext: ZIO[Any, AwsError, Context] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.Step
  ) extends zio.aws.amplify.model.Step.ReadOnly {
    override val stepName: StepName =
      zio.aws.amplify.model.primitives.StepName(impl.stepName())
    override val startTime: StartTime =
      zio.aws.amplify.model.primitives.StartTime(impl.startTime())
    override val status: zio.aws.amplify.model.JobStatus =
      zio.aws.amplify.model.JobStatus.wrap(impl.status())
    override val endTime: EndTime =
      zio.aws.amplify.model.primitives.EndTime(impl.endTime())
    override val logUrl: Optional[LogUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.logUrl())
      .map(value => zio.aws.amplify.model.primitives.LogUrl(value))
    override val artifactsUrl: Optional[ArtifactsUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactsUrl())
      .map(value => zio.aws.amplify.model.primitives.ArtifactsUrl(value))
    override val testArtifactsUrl: Optional[TestArtifactsUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testArtifactsUrl())
        .map(value => zio.aws.amplify.model.primitives.TestArtifactsUrl(value))
    override val testConfigUrl: Optional[TestConfigUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.testConfigUrl())
      .map(value => zio.aws.amplify.model.primitives.TestConfigUrl(value))
    override val screenshots: Optional[Map[ThumbnailName, ThumbnailUrl]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.screenshots())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.amplify.model.primitives.ThumbnailName(
                key
              ) -> zio.aws.amplify.model.primitives.ThumbnailUrl(value)
            })
            .toMap
        )
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.amplify.model.primitives.StatusReason(value))
    override val context: Optional[Context] = zio.aws.core.internal
      .optionalFromNullable(impl.context())
      .map(value => zio.aws.amplify.model.primitives.Context(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.Step
  ): zio.aws.amplify.model.Step.ReadOnly = new Wrapper(impl)
}
