package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{DNSRecord, Verified}
import scala.jdk.CollectionConverters.*
final case class SubDomain(
    subDomainSetting: zio.aws.amplify.model.SubDomainSetting,
    verified: Verified,
    dnsRecord: DNSRecord
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.SubDomain = {
    import SubDomain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.SubDomain
      .builder()
      .subDomainSetting(subDomainSetting.buildAwsValue())
      .verified(Verified.unwrap(verified): java.lang.Boolean)
      .dnsRecord(DNSRecord.unwrap(dnsRecord): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.SubDomain.ReadOnly =
    zio.aws.amplify.model.SubDomain.wrap(buildAwsValue())
}
object SubDomain {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.SubDomain] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.SubDomain = zio.aws.amplify.model
      .SubDomain(subDomainSetting.asEditable, verified, dnsRecord)
    def subDomainSetting: zio.aws.amplify.model.SubDomainSetting.ReadOnly
    def verified: Verified
    def dnsRecord: DNSRecord
    def getSubDomainSetting
        : ZIO[Any, Nothing, zio.aws.amplify.model.SubDomainSetting.ReadOnly] =
      ZIO.succeed(subDomainSetting)
    def getVerified: ZIO[Any, Nothing, Verified] = ZIO.succeed(verified)
    def getDnsRecord: ZIO[Any, Nothing, DNSRecord] = ZIO.succeed(dnsRecord)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.SubDomain
  ) extends zio.aws.amplify.model.SubDomain.ReadOnly {
    override val subDomainSetting
        : zio.aws.amplify.model.SubDomainSetting.ReadOnly =
      zio.aws.amplify.model.SubDomainSetting.wrap(impl.subDomainSetting())
    override val verified: Verified =
      zio.aws.amplify.model.primitives.Verified(impl.verified())
    override val dnsRecord: DNSRecord =
      zio.aws.amplify.model.primitives.DNSRecord(impl.dnsRecord())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.SubDomain
  ): zio.aws.amplify.model.SubDomain.ReadOnly = new Wrapper(impl)
}
