package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  EnableBasicAuth,
  EnableAutoBuild,
  CustomHeaders,
  BuildSpec,
  EnableAutoBranchCreation,
  Repository,
  BasicAuthCredentials,
  ServiceRoleArn,
  Description,
  AutoBranchCreationPattern,
  AppId,
  EnvValue,
  EnvKey,
  EnableBranchAutoDeletion,
  OauthToken,
  Name,
  AccessToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAppRequest(
    appId: AppId,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    platform: Optional[zio.aws.amplify.model.Platform] = Optional.Absent,
    iamServiceRoleArn: Optional[ServiceRoleArn] = Optional.Absent,
    environmentVariables: Optional[Map[EnvKey, EnvValue]] = Optional.Absent,
    enableBranchAutoBuild: Optional[EnableAutoBuild] = Optional.Absent,
    enableBranchAutoDeletion: Optional[EnableBranchAutoDeletion] =
      Optional.Absent,
    enableBasicAuth: Optional[EnableBasicAuth] = Optional.Absent,
    basicAuthCredentials: Optional[BasicAuthCredentials] = Optional.Absent,
    customRules: Optional[Iterable[zio.aws.amplify.model.CustomRule]] =
      Optional.Absent,
    buildSpec: Optional[BuildSpec] = Optional.Absent,
    customHeaders: Optional[CustomHeaders] = Optional.Absent,
    enableAutoBranchCreation: Optional[EnableAutoBranchCreation] =
      Optional.Absent,
    autoBranchCreationPatterns: Optional[Iterable[AutoBranchCreationPattern]] =
      Optional.Absent,
    autoBranchCreationConfig: Optional[
      zio.aws.amplify.model.AutoBranchCreationConfig
    ] = Optional.Absent,
    repository: Optional[Repository] = Optional.Absent,
    oauthToken: Optional[OauthToken] = Optional.Absent,
    accessToken: Optional[AccessToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateAppRequest = {
    import UpdateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateAppRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        iamServiceRoleArn.map(value =>
          ServiceRoleArn.unwrap(value): java.lang.String
        )
      )(_.iamServiceRoleArn)
      .optionallyWith(
        environmentVariables.map(value =>
          value
            .map({ case (key, value) =>
              (EnvKey.unwrap(key): java.lang.String) -> (EnvValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environmentVariables)
      .optionallyWith(
        enableBranchAutoBuild.map(value =>
          EnableAutoBuild.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoBuild)
      .optionallyWith(
        enableBranchAutoDeletion.map(value =>
          EnableBranchAutoDeletion.unwrap(value): java.lang.Boolean
        )
      )(_.enableBranchAutoDeletion)
      .optionallyWith(
        enableBasicAuth.map(value =>
          EnableBasicAuth.unwrap(value): java.lang.Boolean
        )
      )(_.enableBasicAuth)
      .optionallyWith(
        basicAuthCredentials.map(value =>
          BasicAuthCredentials.unwrap(value): java.lang.String
        )
      )(_.basicAuthCredentials)
      .optionallyWith(
        customRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customRules)
      .optionallyWith(
        buildSpec.map(value => BuildSpec.unwrap(value): java.lang.String)
      )(_.buildSpec)
      .optionallyWith(
        customHeaders.map(value =>
          CustomHeaders.unwrap(value): java.lang.String
        )
      )(_.customHeaders)
      .optionallyWith(
        enableAutoBranchCreation.map(value =>
          EnableAutoBranchCreation.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoBranchCreation)
      .optionallyWith(
        autoBranchCreationPatterns.map(value =>
          value.map { item =>
            AutoBranchCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoBranchCreationPatterns)
      .optionallyWith(
        autoBranchCreationConfig.map(value => value.buildAwsValue())
      )(_.autoBranchCreationConfig)
      .optionallyWith(
        repository.map(value => Repository.unwrap(value): java.lang.String)
      )(_.repository)
      .optionallyWith(
        oauthToken.map(value => OauthToken.unwrap(value): java.lang.String)
      )(_.oauthToken)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateAppRequest.ReadOnly =
    zio.aws.amplify.model.UpdateAppRequest.wrap(buildAwsValue())
}
object UpdateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateAppRequest =
      zio.aws.amplify.model.UpdateAppRequest(
        appId,
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        iamServiceRoleArn.map(value => value),
        environmentVariables.map(value => value),
        enableBranchAutoBuild.map(value => value),
        enableBranchAutoDeletion.map(value => value),
        enableBasicAuth.map(value => value),
        basicAuthCredentials.map(value => value),
        customRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        buildSpec.map(value => value),
        customHeaders.map(value => value),
        enableAutoBranchCreation.map(value => value),
        autoBranchCreationPatterns.map(value => value),
        autoBranchCreationConfig.map(value => value.asEditable),
        repository.map(value => value),
        oauthToken.map(value => value),
        accessToken.map(value => value)
      )
    def appId: AppId
    def name: Optional[Name]
    def description: Optional[Description]
    def platform: Optional[zio.aws.amplify.model.Platform]
    def iamServiceRoleArn: Optional[ServiceRoleArn]
    def environmentVariables: Optional[Map[EnvKey, EnvValue]]
    def enableBranchAutoBuild: Optional[EnableAutoBuild]
    def enableBranchAutoDeletion: Optional[EnableBranchAutoDeletion]
    def enableBasicAuth: Optional[EnableBasicAuth]
    def basicAuthCredentials: Optional[BasicAuthCredentials]
    def customRules: Optional[List[zio.aws.amplify.model.CustomRule.ReadOnly]]
    def buildSpec: Optional[BuildSpec]
    def customHeaders: Optional[CustomHeaders]
    def enableAutoBranchCreation: Optional[EnableAutoBranchCreation]
    def autoBranchCreationPatterns: Optional[List[AutoBranchCreationPattern]]
    def autoBranchCreationConfig
        : Optional[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly]
    def repository: Optional[Repository]
    def oauthToken: Optional[OauthToken]
    def accessToken: Optional[AccessToken]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.amplify.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getIamServiceRoleArn: ZIO[Any, AwsError, ServiceRoleArn] =
      AwsError.unwrapOptionField("iamServiceRoleArn", iamServiceRoleArn)
    def getEnvironmentVariables: ZIO[Any, AwsError, Map[EnvKey, EnvValue]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getEnableBranchAutoBuild: ZIO[Any, AwsError, EnableAutoBuild] =
      AwsError.unwrapOptionField("enableBranchAutoBuild", enableBranchAutoBuild)
    def getEnableBranchAutoDeletion
        : ZIO[Any, AwsError, EnableBranchAutoDeletion] = AwsError
      .unwrapOptionField("enableBranchAutoDeletion", enableBranchAutoDeletion)
    def getEnableBasicAuth: ZIO[Any, AwsError, EnableBasicAuth] =
      AwsError.unwrapOptionField("enableBasicAuth", enableBasicAuth)
    def getBasicAuthCredentials: ZIO[Any, AwsError, BasicAuthCredentials] =
      AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getCustomRules
        : ZIO[Any, AwsError, List[zio.aws.amplify.model.CustomRule.ReadOnly]] =
      AwsError.unwrapOptionField("customRules", customRules)
    def getBuildSpec: ZIO[Any, AwsError, BuildSpec] =
      AwsError.unwrapOptionField("buildSpec", buildSpec)
    def getCustomHeaders: ZIO[Any, AwsError, CustomHeaders] =
      AwsError.unwrapOptionField("customHeaders", customHeaders)
    def getEnableAutoBranchCreation
        : ZIO[Any, AwsError, EnableAutoBranchCreation] = AwsError
      .unwrapOptionField("enableAutoBranchCreation", enableAutoBranchCreation)
    def getAutoBranchCreationPatterns
        : ZIO[Any, AwsError, List[AutoBranchCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoBranchCreationPatterns",
        autoBranchCreationPatterns
      )
    def getAutoBranchCreationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoBranchCreationConfig",
      autoBranchCreationConfig
    )
    def getRepository: ZIO[Any, AwsError, Repository] =
      AwsError.unwrapOptionField("repository", repository)
    def getOauthToken: ZIO[Any, AwsError, OauthToken] =
      AwsError.unwrapOptionField("oauthToken", oauthToken)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ) extends zio.aws.amplify.model.UpdateAppRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.amplify.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
    override val platform: Optional[zio.aws.amplify.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.amplify.model.Platform.wrap(value))
    override val iamServiceRoleArn: Optional[ServiceRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamServiceRoleArn())
        .map(value => zio.aws.amplify.model.primitives.ServiceRoleArn(value))
    override val environmentVariables: Optional[Map[EnvKey, EnvValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.amplify.model.primitives
                .EnvKey(key) -> zio.aws.amplify.model.primitives.EnvValue(value)
            })
            .toMap
        )
    override val enableBranchAutoBuild: Optional[EnableAutoBuild] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBranchAutoBuild())
        .map(value => zio.aws.amplify.model.primitives.EnableAutoBuild(value))
    override val enableBranchAutoDeletion: Optional[EnableBranchAutoDeletion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBranchAutoDeletion())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableBranchAutoDeletion(value)
        )
    override val enableBasicAuth: Optional[EnableBasicAuth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableBasicAuth())
        .map(value => zio.aws.amplify.model.primitives.EnableBasicAuth(value))
    override val basicAuthCredentials: Optional[BasicAuthCredentials] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basicAuthCredentials())
        .map(value =>
          zio.aws.amplify.model.primitives.BasicAuthCredentials(value)
        )
    override val customRules
        : Optional[List[zio.aws.amplify.model.CustomRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplify.model.CustomRule.wrap(item)
          }.toList
        )
    override val buildSpec: Optional[BuildSpec] = zio.aws.core.internal
      .optionalFromNullable(impl.buildSpec())
      .map(value => zio.aws.amplify.model.primitives.BuildSpec(value))
    override val customHeaders: Optional[CustomHeaders] = zio.aws.core.internal
      .optionalFromNullable(impl.customHeaders())
      .map(value => zio.aws.amplify.model.primitives.CustomHeaders(value))
    override val enableAutoBranchCreation: Optional[EnableAutoBranchCreation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAutoBranchCreation())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableAutoBranchCreation(value)
        )
    override val autoBranchCreationPatterns
        : Optional[List[AutoBranchCreationPattern]] = zio.aws.core.internal
      .optionalFromNullable(impl.autoBranchCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoBranchCreationPattern(item)
        }.toList
      )
    override val autoBranchCreationConfig
        : Optional[zio.aws.amplify.model.AutoBranchCreationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoBranchCreationConfig())
        .map(value =>
          zio.aws.amplify.model.AutoBranchCreationConfig.wrap(value)
        )
    override val repository: Optional[Repository] = zio.aws.core.internal
      .optionalFromNullable(impl.repository())
      .map(value => zio.aws.amplify.model.primitives.Repository(value))
    override val oauthToken: Optional[OauthToken] = zio.aws.core.internal
      .optionalFromNullable(impl.oauthToken())
      .map(value => zio.aws.amplify.model.primitives.OauthToken(value))
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.amplify.model.primitives.AccessToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateAppRequest
  ): zio.aws.amplify.model.UpdateAppRequest.ReadOnly = new Wrapper(impl)
}
