package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  DomainName,
  AutoSubDomainIAMRole,
  AppId,
  EnableAutoSubDomain,
  AutoSubDomainCreationPattern
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDomainAssociationRequest(
    appId: AppId,
    domainName: DomainName,
    enableAutoSubDomain: Optional[EnableAutoSubDomain] = Optional.Absent,
    subDomainSettings: Optional[
      Iterable[zio.aws.amplify.model.SubDomainSetting]
    ] = Optional.Absent,
    autoSubDomainCreationPatterns: Optional[
      Iterable[AutoSubDomainCreationPattern]
    ] = Optional.Absent,
    autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest = {
    import UpdateDomainAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        enableAutoSubDomain.map(value =>
          EnableAutoSubDomain.unwrap(value): java.lang.Boolean
        )
      )(_.enableAutoSubDomain)
      .optionallyWith(
        subDomainSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subDomainSettings)
      .optionallyWith(
        autoSubDomainCreationPatterns.map(value =>
          value.map { item =>
            AutoSubDomainCreationPattern.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoSubDomainCreationPatterns)
      .optionallyWith(
        autoSubDomainIAMRole.map(value =>
          AutoSubDomainIAMRole.unwrap(value): java.lang.String
        )
      )(_.autoSubDomainIAMRole)
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.UpdateDomainAssociationRequest.ReadOnly =
    zio.aws.amplify.model.UpdateDomainAssociationRequest.wrap(buildAwsValue())
}
object UpdateDomainAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateDomainAssociationRequest =
      zio.aws.amplify.model.UpdateDomainAssociationRequest(
        appId,
        domainName,
        enableAutoSubDomain.map(value => value),
        subDomainSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoSubDomainCreationPatterns.map(value => value),
        autoSubDomainIAMRole.map(value => value)
      )
    def appId: AppId
    def domainName: DomainName
    def enableAutoSubDomain: Optional[EnableAutoSubDomain]
    def subDomainSettings
        : Optional[List[zio.aws.amplify.model.SubDomainSetting.ReadOnly]]
    def autoSubDomainCreationPatterns
        : Optional[List[AutoSubDomainCreationPattern]]
    def autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getEnableAutoSubDomain: ZIO[Any, AwsError, EnableAutoSubDomain] =
      AwsError.unwrapOptionField("enableAutoSubDomain", enableAutoSubDomain)
    def getSubDomainSettings: ZIO[Any, AwsError, List[
      zio.aws.amplify.model.SubDomainSetting.ReadOnly
    ]] = AwsError.unwrapOptionField("subDomainSettings", subDomainSettings)
    def getAutoSubDomainCreationPatterns
        : ZIO[Any, AwsError, List[AutoSubDomainCreationPattern]] =
      AwsError.unwrapOptionField(
        "autoSubDomainCreationPatterns",
        autoSubDomainCreationPatterns
      )
    def getAutoSubDomainIAMRole: ZIO[Any, AwsError, AutoSubDomainIAMRole] =
      AwsError.unwrapOptionField("autoSubDomainIAMRole", autoSubDomainIAMRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest
  ) extends zio.aws.amplify.model.UpdateDomainAssociationRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val domainName: DomainName =
      zio.aws.amplify.model.primitives.DomainName(impl.domainName())
    override val enableAutoSubDomain: Optional[EnableAutoSubDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAutoSubDomain())
        .map(value =>
          zio.aws.amplify.model.primitives.EnableAutoSubDomain(value)
        )
    override val subDomainSettings
        : Optional[List[zio.aws.amplify.model.SubDomainSetting.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subDomainSettings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.amplify.model.SubDomainSetting.wrap(item)
          }.toList
        )
    override val autoSubDomainCreationPatterns
        : Optional[List[AutoSubDomainCreationPattern]] = zio.aws.core.internal
      .optionalFromNullable(impl.autoSubDomainCreationPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.amplify.model.primitives.AutoSubDomainCreationPattern(item)
        }.toList
      )
    override val autoSubDomainIAMRole: Optional[AutoSubDomainIAMRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoSubDomainIAMRole())
        .map(value =>
          zio.aws.amplify.model.primitives.AutoSubDomainIAMRole(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateDomainAssociationRequest
  ): zio.aws.amplify.model.UpdateDomainAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
