package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWebhookResponse(webhook: zio.aws.amplify.model.Webhook) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse = {
    import UpdateWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse
      .builder()
      .webhook(webhook.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly =
    zio.aws.amplify.model.UpdateWebhookResponse.wrap(buildAwsValue())
}
object UpdateWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.UpdateWebhookResponse =
      zio.aws.amplify.model.UpdateWebhookResponse(webhook.asEditable)
    def webhook: zio.aws.amplify.model.Webhook.ReadOnly
    def getWebhook: ZIO[Any, Nothing, zio.aws.amplify.model.Webhook.ReadOnly] =
      ZIO.succeed(webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse
  ) extends zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly {
    override val webhook: zio.aws.amplify.model.Webhook.ReadOnly =
      zio.aws.amplify.model.Webhook.wrap(impl.webhook())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.UpdateWebhookResponse
  ): zio.aws.amplify.model.UpdateWebhookResponse.ReadOnly = new Wrapper(impl)
}
