package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{ArtifactId, ArtifactFileName}
import scala.jdk.CollectionConverters.*
final case class Artifact(
    artifactFileName: ArtifactFileName,
    artifactId: ArtifactId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.Artifact = {
    import Artifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.Artifact
      .builder()
      .artifactFileName(
        ArtifactFileName.unwrap(artifactFileName): java.lang.String
      )
      .artifactId(ArtifactId.unwrap(artifactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.Artifact.ReadOnly =
    zio.aws.amplify.model.Artifact.wrap(buildAwsValue())
}
object Artifact {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.amplify.model.Artifact] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.Artifact =
      zio.aws.amplify.model.Artifact(artifactFileName, artifactId)
    def artifactFileName: ArtifactFileName
    def artifactId: ArtifactId
    def getArtifactFileName: ZIO[Any, Nothing, ArtifactFileName] =
      ZIO.succeed(artifactFileName)
    def getArtifactId: ZIO[Any, Nothing, ArtifactId] = ZIO.succeed(artifactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.Artifact
  ) extends zio.aws.amplify.model.Artifact.ReadOnly {
    override val artifactFileName: ArtifactFileName =
      zio.aws.amplify.model.primitives.ArtifactFileName(impl.artifactFileName())
    override val artifactId: ArtifactId =
      zio.aws.amplify.model.primitives.ArtifactId(impl.artifactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.Artifact
  ): zio.aws.amplify.model.Artifact.ReadOnly = new Wrapper(impl)
}
