package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{
  DeploymentArtifacts,
  StackName,
  EnvironmentName,
  AppId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateBackendEnvironmentRequest(
    appId: AppId,
    environmentName: EnvironmentName,
    stackName: Optional[StackName] = Optional.Absent,
    deploymentArtifacts: Optional[DeploymentArtifacts] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest = {
    import CreateBackendEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        deploymentArtifacts.map(value =>
          DeploymentArtifacts.unwrap(value): java.lang.String
        )
      )(_.deploymentArtifacts)
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.CreateBackendEnvironmentRequest.ReadOnly =
    zio.aws.amplify.model.CreateBackendEnvironmentRequest.wrap(buildAwsValue())
}
object CreateBackendEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateBackendEnvironmentRequest =
      zio.aws.amplify.model.CreateBackendEnvironmentRequest(
        appId,
        environmentName,
        stackName.map(value => value),
        deploymentArtifacts.map(value => value)
      )
    def appId: AppId
    def environmentName: EnvironmentName
    def stackName: Optional[StackName]
    def deploymentArtifacts: Optional[DeploymentArtifacts]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getDeploymentArtifacts: ZIO[Any, AwsError, DeploymentArtifacts] =
      AwsError.unwrapOptionField("deploymentArtifacts", deploymentArtifacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest
  ) extends zio.aws.amplify.model.CreateBackendEnvironmentRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val environmentName: EnvironmentName =
      zio.aws.amplify.model.primitives.EnvironmentName(impl.environmentName())
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.amplify.model.primitives.StackName(value))
    override val deploymentArtifacts: Optional[DeploymentArtifacts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentArtifacts())
        .map(value =>
          zio.aws.amplify.model.primitives.DeploymentArtifacts(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateBackendEnvironmentRequest
  ): zio.aws.amplify.model.CreateBackendEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
