package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateBranchResponse(branch: zio.aws.amplify.model.Branch) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateBranchResponse = {
    import CreateBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateBranchResponse
      .builder()
      .branch(branch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateBranchResponse.ReadOnly =
    zio.aws.amplify.model.CreateBranchResponse.wrap(buildAwsValue())
}
object CreateBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateBranchResponse =
      zio.aws.amplify.model.CreateBranchResponse(branch.asEditable)
    def branch: zio.aws.amplify.model.Branch.ReadOnly
    def getBranch: ZIO[Any, Nothing, zio.aws.amplify.model.Branch.ReadOnly] =
      ZIO.succeed(branch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateBranchResponse
  ) extends zio.aws.amplify.model.CreateBranchResponse.ReadOnly {
    override val branch: zio.aws.amplify.model.Branch.ReadOnly =
      zio.aws.amplify.model.Branch.wrap(impl.branch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateBranchResponse
  ): zio.aws.amplify.model.CreateBranchResponse.ReadOnly = new Wrapper(impl)
}
