package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{MD5Hash, FileName, BranchName, AppId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentRequest(
    appId: AppId,
    branchName: BranchName,
    fileMap: Optional[Map[FileName, MD5Hash]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest = {
    import CreateDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        fileMap.map(value =>
          value
            .map({ case (key, value) =>
              (FileName.unwrap(key): java.lang.String) -> (MD5Hash
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.fileMap)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateDeploymentRequest.ReadOnly =
    zio.aws.amplify.model.CreateDeploymentRequest.wrap(buildAwsValue())
}
object CreateDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateDeploymentRequest =
      zio.aws.amplify.model
        .CreateDeploymentRequest(appId, branchName, fileMap.map(value => value))
    def appId: AppId
    def branchName: BranchName
    def fileMap: Optional[Map[FileName, MD5Hash]]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getFileMap: ZIO[Any, AwsError, Map[FileName, MD5Hash]] =
      AwsError.unwrapOptionField("fileMap", fileMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest
  ) extends zio.aws.amplify.model.CreateDeploymentRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val fileMap: Optional[Map[FileName, MD5Hash]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileMap())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.amplify.model.primitives.FileName(
                key
              ) -> zio.aws.amplify.model.primitives.MD5Hash(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateDeploymentRequest
  ): zio.aws.amplify.model.CreateDeploymentRequest.ReadOnly = new Wrapper(impl)
}
