package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.amplify.model.primitives.{Description, BranchName, AppId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWebhookRequest(
    appId: AppId,
    branchName: BranchName,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateWebhookRequest = {
    import CreateWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateWebhookRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateWebhookRequest.ReadOnly =
    zio.aws.amplify.model.CreateWebhookRequest.wrap(buildAwsValue())
}
object CreateWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateWebhookRequest =
      zio.aws.amplify.model.CreateWebhookRequest(
        appId,
        branchName,
        description.map(value => value)
      )
    def appId: AppId
    def branchName: BranchName
    def description: Optional[Description]
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateWebhookRequest
  ) extends zio.aws.amplify.model.CreateWebhookRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.amplify.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateWebhookRequest
  ): zio.aws.amplify.model.CreateWebhookRequest.ReadOnly = new Wrapper(impl)
}
