package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateWebhookResponse(webhook: zio.aws.amplify.model.Webhook) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.CreateWebhookResponse = {
    import CreateWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.CreateWebhookResponse
      .builder()
      .webhook(webhook.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.CreateWebhookResponse.ReadOnly =
    zio.aws.amplify.model.CreateWebhookResponse.wrap(buildAwsValue())
}
object CreateWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.CreateWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.CreateWebhookResponse =
      zio.aws.amplify.model.CreateWebhookResponse(webhook.asEditable)
    def webhook: zio.aws.amplify.model.Webhook.ReadOnly
    def getWebhook: ZIO[Any, Nothing, zio.aws.amplify.model.Webhook.ReadOnly] =
      ZIO.succeed(webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.CreateWebhookResponse
  ) extends zio.aws.amplify.model.CreateWebhookResponse.ReadOnly {
    override val webhook: zio.aws.amplify.model.Webhook.ReadOnly =
      zio.aws.amplify.model.Webhook.wrap(impl.webhook())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.CreateWebhookResponse
  ): zio.aws.amplify.model.CreateWebhookResponse.ReadOnly = new Wrapper(impl)
}
