package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.AppId
import scala.jdk.CollectionConverters.*
final case class DeleteAppRequest(appId: AppId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteAppRequest = {
    import DeleteAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteAppRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteAppRequest.ReadOnly =
    zio.aws.amplify.model.DeleteAppRequest.wrap(buildAwsValue())
}
object DeleteAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteAppRequest =
      zio.aws.amplify.model.DeleteAppRequest(appId)
    def appId: AppId
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteAppRequest
  ) extends zio.aws.amplify.model.DeleteAppRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteAppRequest
  ): zio.aws.amplify.model.DeleteAppRequest.ReadOnly = new Wrapper(impl)
}
