package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBackendEnvironmentResponse(
    backendEnvironment: zio.aws.amplify.model.BackendEnvironment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse = {
    import DeleteBackendEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse
      .builder()
      .backendEnvironment(backendEnvironment.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly =
    zio.aws.amplify.model.DeleteBackendEnvironmentResponse.wrap(buildAwsValue())
}
object DeleteBackendEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteBackendEnvironmentResponse =
      zio.aws.amplify.model
        .DeleteBackendEnvironmentResponse(backendEnvironment.asEditable)
    def backendEnvironment: zio.aws.amplify.model.BackendEnvironment.ReadOnly
    def getBackendEnvironment
        : ZIO[Any, Nothing, zio.aws.amplify.model.BackendEnvironment.ReadOnly] =
      ZIO.succeed(backendEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse
  ) extends zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly {
    override val backendEnvironment
        : zio.aws.amplify.model.BackendEnvironment.ReadOnly =
      zio.aws.amplify.model.BackendEnvironment.wrap(impl.backendEnvironment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBackendEnvironmentResponse
  ): zio.aws.amplify.model.DeleteBackendEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
