package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{BranchName, AppId}
import scala.jdk.CollectionConverters.*
final case class DeleteBranchRequest(appId: AppId, branchName: BranchName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteBranchRequest = {
    import DeleteBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteBranchRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteBranchRequest.ReadOnly =
    zio.aws.amplify.model.DeleteBranchRequest.wrap(buildAwsValue())
}
object DeleteBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteBranchRequest =
      zio.aws.amplify.model.DeleteBranchRequest(appId, branchName)
    def appId: AppId
    def branchName: BranchName
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBranchRequest
  ) extends zio.aws.amplify.model.DeleteBranchRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteBranchRequest
  ): zio.aws.amplify.model.DeleteBranchRequest.ReadOnly = new Wrapper(impl)
}
