package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{JobId, BranchName, AppId}
import scala.jdk.CollectionConverters.*
final case class DeleteJobRequest(
    appId: AppId,
    branchName: BranchName,
    jobId: JobId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteJobRequest = {
    import DeleteJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteJobRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteJobRequest.ReadOnly =
    zio.aws.amplify.model.DeleteJobRequest.wrap(buildAwsValue())
}
object DeleteJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteJobRequest =
      zio.aws.amplify.model.DeleteJobRequest(appId, branchName, jobId)
    def appId: AppId
    def branchName: BranchName
    def jobId: JobId
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteJobRequest
  ) extends zio.aws.amplify.model.DeleteJobRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
    override val jobId: JobId =
      zio.aws.amplify.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteJobRequest
  ): zio.aws.amplify.model.DeleteJobRequest.ReadOnly = new Wrapper(impl)
}
