package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteWebhookResponse(webhook: zio.aws.amplify.model.Webhook) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse = {
    import DeleteWebhookResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse
      .builder()
      .webhook(webhook.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly =
    zio.aws.amplify.model.DeleteWebhookResponse.wrap(buildAwsValue())
}
object DeleteWebhookResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.DeleteWebhookResponse =
      zio.aws.amplify.model.DeleteWebhookResponse(webhook.asEditable)
    def webhook: zio.aws.amplify.model.Webhook.ReadOnly
    def getWebhook: ZIO[Any, Nothing, zio.aws.amplify.model.Webhook.ReadOnly] =
      ZIO.succeed(webhook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse
  ) extends zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly {
    override val webhook: zio.aws.amplify.model.Webhook.ReadOnly =
      zio.aws.amplify.model.Webhook.wrap(impl.webhook())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.DeleteWebhookResponse
  ): zio.aws.amplify.model.DeleteWebhookResponse.ReadOnly = new Wrapper(impl)
}
