package zio.aws.amplify.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.amplify.model.primitives.{AppId, DomainName, EndTime, StartTime}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GenerateAccessLogsRequest(
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent,
    domainName: DomainName,
    appId: AppId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest = {
    import GenerateAccessLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest
      .builder()
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .appId(AppId.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GenerateAccessLogsRequest.ReadOnly =
    zio.aws.amplify.model.GenerateAccessLogsRequest.wrap(buildAwsValue())
}
object GenerateAccessLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GenerateAccessLogsRequest =
      zio.aws.amplify.model.GenerateAccessLogsRequest(
        startTime.map(value => value),
        endTime.map(value => value),
        domainName,
        appId
      )
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def domainName: DomainName
    def appId: AppId
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest
  ) extends zio.aws.amplify.model.GenerateAccessLogsRequest.ReadOnly {
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.amplify.model.primitives.StartTime(value))
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.amplify.model.primitives.EndTime(value))
    override val domainName: DomainName =
      zio.aws.amplify.model.primitives.DomainName(impl.domainName())
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GenerateAccessLogsRequest
  ): zio.aws.amplify.model.GenerateAccessLogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
