package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{EnvironmentName, AppId}
import scala.jdk.CollectionConverters.*
final case class GetBackendEnvironmentRequest(
    appId: AppId,
    environmentName: EnvironmentName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest = {
    import GetBackendEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .environmentName(
        EnvironmentName.unwrap(environmentName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetBackendEnvironmentRequest.ReadOnly =
    zio.aws.amplify.model.GetBackendEnvironmentRequest.wrap(buildAwsValue())
}
object GetBackendEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetBackendEnvironmentRequest =
      zio.aws.amplify.model.GetBackendEnvironmentRequest(appId, environmentName)
    def appId: AppId
    def environmentName: EnvironmentName
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getEnvironmentName: ZIO[Any, Nothing, EnvironmentName] =
      ZIO.succeed(environmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest
  ) extends zio.aws.amplify.model.GetBackendEnvironmentRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val environmentName: EnvironmentName =
      zio.aws.amplify.model.primitives.EnvironmentName(impl.environmentName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentRequest
  ): zio.aws.amplify.model.GetBackendEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
