package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBackendEnvironmentResponse(
    backendEnvironment: zio.aws.amplify.model.BackendEnvironment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse = {
    import GetBackendEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse
      .builder()
      .backendEnvironment(backendEnvironment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly =
    zio.aws.amplify.model.GetBackendEnvironmentResponse.wrap(buildAwsValue())
}
object GetBackendEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetBackendEnvironmentResponse =
      zio.aws.amplify.model
        .GetBackendEnvironmentResponse(backendEnvironment.asEditable)
    def backendEnvironment: zio.aws.amplify.model.BackendEnvironment.ReadOnly
    def getBackendEnvironment
        : ZIO[Any, Nothing, zio.aws.amplify.model.BackendEnvironment.ReadOnly] =
      ZIO.succeed(backendEnvironment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse
  ) extends zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly {
    override val backendEnvironment
        : zio.aws.amplify.model.BackendEnvironment.ReadOnly =
      zio.aws.amplify.model.BackendEnvironment.wrap(impl.backendEnvironment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetBackendEnvironmentResponse
  ): zio.aws.amplify.model.GetBackendEnvironmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
