package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.{BranchName, AppId}
import scala.jdk.CollectionConverters.*
final case class GetBranchRequest(appId: AppId, branchName: BranchName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetBranchRequest = {
    import GetBranchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetBranchRequest
      .builder()
      .appId(AppId.unwrap(appId): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetBranchRequest.ReadOnly =
    zio.aws.amplify.model.GetBranchRequest.wrap(buildAwsValue())
}
object GetBranchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetBranchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetBranchRequest =
      zio.aws.amplify.model.GetBranchRequest(appId, branchName)
    def appId: AppId
    def branchName: BranchName
    def getAppId: ZIO[Any, Nothing, AppId] = ZIO.succeed(appId)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetBranchRequest
  ) extends zio.aws.amplify.model.GetBranchRequest.ReadOnly {
    override val appId: AppId =
      zio.aws.amplify.model.primitives.AppId(impl.appId())
    override val branchName: BranchName =
      zio.aws.amplify.model.primitives.BranchName(impl.branchName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetBranchRequest
  ): zio.aws.amplify.model.GetBranchRequest.ReadOnly = new Wrapper(impl)
}
