package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetBranchResponse(branch: zio.aws.amplify.model.Branch) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetBranchResponse = {
    import GetBranchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetBranchResponse
      .builder()
      .branch(branch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetBranchResponse.ReadOnly =
    zio.aws.amplify.model.GetBranchResponse.wrap(buildAwsValue())
}
object GetBranchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetBranchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetBranchResponse =
      zio.aws.amplify.model.GetBranchResponse(branch.asEditable)
    def branch: zio.aws.amplify.model.Branch.ReadOnly
    def getBranch: ZIO[Any, Nothing, zio.aws.amplify.model.Branch.ReadOnly] =
      ZIO.succeed(branch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetBranchResponse
  ) extends zio.aws.amplify.model.GetBranchResponse.ReadOnly {
    override val branch: zio.aws.amplify.model.Branch.ReadOnly =
      zio.aws.amplify.model.Branch.wrap(impl.branch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetBranchResponse
  ): zio.aws.amplify.model.GetBranchResponse.ReadOnly = new Wrapper(impl)
}
