package zio.aws.amplify.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.amplify.model.primitives.WebhookId
import scala.jdk.CollectionConverters.*
final case class GetWebhookRequest(webhookId: WebhookId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.amplify.model.GetWebhookRequest = {
    import GetWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.amplify.model.GetWebhookRequest
      .builder()
      .webhookId(WebhookId.unwrap(webhookId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.amplify.model.GetWebhookRequest.ReadOnly =
    zio.aws.amplify.model.GetWebhookRequest.wrap(buildAwsValue())
}
object GetWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.amplify.model.GetWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.amplify.model.GetWebhookRequest =
      zio.aws.amplify.model.GetWebhookRequest(webhookId)
    def webhookId: WebhookId
    def getWebhookId: ZIO[Any, Nothing, WebhookId] = ZIO.succeed(webhookId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.amplify.model.GetWebhookRequest
  ) extends zio.aws.amplify.model.GetWebhookRequest.ReadOnly {
    override val webhookId: WebhookId =
      zio.aws.amplify.model.primitives.WebhookId(impl.webhookId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.amplify.model.GetWebhookRequest
  ): zio.aws.amplify.model.GetWebhookRequest.ReadOnly = new Wrapper(impl)
}
